/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.services.sys.http;

import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.httpserver.httpservice.BaseHttpService;
import com.simba.common.common.httpserver.httpservice.IHttpRequest;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.wcsclient.actions.ServiceUser;
import com.simba.server.wcsclient.models.DaoRole;
import com.simba.server.wcsclient.models.DaoUser;
import com.simba.server.wcsclient.services.utils.ResponseUtil;
import com.simba.server.wcsclient.services.utils.TypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class UserHttpService
extends BaseHttpService {
    public static final String NAME = "user_sys";
    private static final Logger logger = Logger.getLogger(UserHttpService.class);

    @IHttpRequest(Url="get_role", Method="POST")
    public void GetRole(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> result;
        String id = this.getStringByParam(map, "id");
        if (StringUtil.isNull(id).booleanValue()) {
            Map<String, Object> result2 = ResponseUtil.CreateResponseMap(false, "\u7528\u6237Id\u4e3a\u7a7a");
            this.renderJson(channel, result2, request);
            return;
        }
        try {
            HashMap<String, ParamBean> param = new HashMap<String, ParamBean>();
            param.put("id", new ParamBean(id));
            Result table = DaoUser.GetInstance().GetAllData(param, null, null, null, null, false);
            param = new HashMap();
            param.put("userId", new ParamBean(id));
            Result roleList = DaoRole.GetInstance().listSysUserRole(param);
            result = ResponseUtil.CreateResponseMap(true, "\u83b7\u53d6\u89d2\u8272\u6210\u529f!");
            result.put("successful", true);
            result.put("user", table.getRows());
            result.put("roleList", roleList.getRows());
        }
        catch (Exception e) {
            result = ResponseUtil.CreateResponseMap(false, "\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        this.renderJson(channel, result, request);
    }

    @IHttpRequest(Url="set_role", Method="POST")
    public void SetRole(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> result;
        String[] roleIdArray = (String[])this.getArrayByParam(map, "roleIdArray", TypeUtil.STRING_ARRAY_TYPE);
        String userId = this.getStringByParam(map, "userId");
        String creator = this.getStringByParam(map, "creator");
        if (StringUtil.isNull(userId).booleanValue()) {
            Map<String, Object> result2 = ResponseUtil.CreateResponseMap(false, "\u7528\u6237Id\u4e3a\u7a7a");
            this.renderJson(channel, result2, request);
            return;
        }
        ArrayList<Map<String, ParamBean>> sysRoleUserList = new ArrayList<Map<String, ParamBean>>();
        if (roleIdArray != null && roleIdArray.length > 0) {
            for (String roleIdStr : roleIdArray) {
                HashMap<String, ParamBean> roleUser = new HashMap<String, ParamBean>();
                roleUser.put("role_id", new ParamBean(roleIdStr));
                roleUser.put("user_id", new ParamBean(userId));
                roleUser.put("create_time", new ParamBean(StringUtil.getDateNow(), 2));
                roleUser.put("creator", new ParamBean(creator));
                sysRoleUserList.add(roleUser);
            }
        }
        try {
            ServiceUser.GetInstance().setSysRoleUser(userId, sysRoleUserList);
            result = ResponseUtil.CreateResponseMap(true, "\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\u6210\u529f");
        }
        catch (Exception ex) {
            result = ResponseUtil.CreateResponseMap(false, "\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\u53d1\u751f\u5f02\u5e38");
            LogManager.LogError(logger, "\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\u5f02\u5e38" + ex.getMessage());
        }
        this.renderJson(channel, result, request);
    }

    @IHttpRequest(Url="set_password", Method="POST")
    public void SetPassword(Channel channel, Map<String, Object> map, HttpRequest request) {
        String userId = this.getStringByParam(map, "workerNumber");
        String password = this.getStringByParam(map, "password");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(password).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u7528\u6237Id\u6216\u8005\u5bc6\u7801\u4e3a\u7a7a");
            this.renderJson(channel, result, request);
            return;
        }
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put("user_password", new ParamBean(password));
        int row = DaoUser.GetInstance().UpdateDataById(maps, userId);
        Map<String, Object> result = row > 0 ? ResponseUtil.CreateResponseMap(true, "\u4fee\u6539\u5bc6\u7801\u6210\u529f") : ResponseUtil.CreateResponseMap(false, "\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
        this.renderJson(channel, result, request);
    }

    @IHttpRequest(Url="get_user_info", Method="POST")
    public void GetUserInfo(Channel channel, Map<String, Object> map, HttpRequest request) {
        String userId = this.getStringByParam(map, "workerNumber");
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put("user_id", new ParamBean(userId));
        DbPageData page = DaoUser.GetInstance().GetDataByPage(0, 1, 1, maps, null, null, null, null, false);
        if (page.getRowCount() < 1) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            this.renderJson(channel, result, request);
            return;
        }
        Map[] table = page.getPageData();
        if (table == null) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            this.renderJson(channel, result, request);
            return;
        }
        Map userInfo = table[0];
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u83b7\u53d6\u4fe1\u606f\u6210\u529f");
        result.put("userInfo", userInfo);
        this.renderJson(channel, result, request);
    }

    @IHttpRequest(Url="set_user_info", Method="POST")
    public void SetUserInfo(Channel channel, Map<String, Object> map, HttpRequest request) {
        String userId = this.getStringByParam(map, "workerNumber");
        Map userInfo = this.getMapByParam(map, "userInfo", TypeUtil.STRING_MAP_OBJECT_TYPE);
        if (userInfo == null) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            this.renderJson(channel, result, request);
            return;
        }
        HashMap<String, ParamBean> params = new HashMap<String, ParamBean>();
        for (String key : userInfo.keySet()) {
            params.put(key, new ParamBean(userInfo.get(key)));
        }
        int row = DaoUser.GetInstance().UpdateDataById(params, userId);
        Map<String, Object> result = row > 0 ? ResponseUtil.CreateResponseMap(true, "\u4fee\u6539\u6210\u529f") : ResponseUtil.CreateResponseMap(false, "\u4fee\u6539\u5931\u8d25");
        this.renderJson(channel, result, request);
    }
}

