/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.services.sys.http;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.httpserver.httpservice.BaseHttpService;
import com.simba.common.common.httpserver.httpservice.IHttpRequest;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.wcsclient.actions.ServiceAction;
import com.simba.server.wcsclient.actions.ServiceMenu;
import com.simba.server.wcsclient.actions.ServiceMessage;
import com.simba.server.wcsclient.models.DaoMenu;
import com.simba.server.wcsclient.services.utils.ResponseUtil;
import com.simba.server.wcsclient.services.utils.TypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class RoleHttpService
extends BaseHttpService {
    public static final String NAME = "role_sys";
    private static final Logger logger = Logger.getLogger(RoleHttpService.class);

    @IHttpRequest(Url="sys_menu_role_info", Method="POST")
    public void GetSysMenuRoleTreeInfo(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> responseParam;
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("roleId", this.getStringByParam(map, "roleId"));
            List<Map<String, Object>> menuList = ServiceMenu.GetInstance().listSysMenuRoleTreeInfo(param);
            responseParam = ResponseUtil.CreateResponseMap(true, "\u83b7\u53d6\u83dc\u5355\u5217\u8868\u6210\u529f!");
            responseParam.put("menuList", menuList);
        }
        catch (Exception e) {
            responseParam = ResponseUtil.CreateResponseMap(false, "\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="sys_action_role_info", Method="POST")
    public void GetSysActionRoleTreeInfo(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> responseParam;
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("roleId", this.getStringByParam(map, "roleId"));
            List<Map<String, Object>> actionList = ServiceAction.GetInstance().listSysActionRoleTreeInfo(param);
            responseParam = ResponseUtil.CreateResponseMap(true, "\u83b7\u53d6\u6743\u9650\u5217\u8868\u6210\u529f!");
            responseParam.put("actionList", actionList);
        }
        catch (Exception e) {
            responseParam = ResponseUtil.CreateResponseMap(false, "\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="sys_message_role_info", Method="POST")
    public void GetSysMessageRoleTreeInfo(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> responseParam;
        try {
            HashMap<String, ParamBean> param = new HashMap<String, ParamBean>();
            param.put("roleId", new ParamBean(this.getStringByParam(map, "roleId")));
            List<Map<String, Object>> messageList = ServiceMessage.GetInstance().listSysMessageRoleTreeInfo(param);
            responseParam = ResponseUtil.CreateResponseMap(true, "\u83b7\u53d6\u6d88\u606f\u6743\u9650\u5217\u8868\u6210\u529f!");
            responseParam.put("messageList", messageList);
        }
        catch (Exception e) {
            responseParam = ResponseUtil.CreateResponseMap(false, "\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="set_role_menu", Method="POST")
    public void SetSysRoleMenu(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> result;
        String[] menuNameArray;
        String currentRoleId = this.getStringByParam(map, "currentRoleId");
        ArrayList<Map<String, ParamBean>> roleMenuList = new ArrayList<Map<String, ParamBean>>();
        for (String menuName : menuNameArray = (String[])this.getArrayByParam(map, "menuNameArray", TypeUtil.STRING_ARRAY_TYPE)) {
            String menuId;
            HashMap<String, ParamBean> param = new HashMap<String, ParamBean>();
            param.put("menu_id", new ParamBean(menuName));
            Result menu = DaoMenu.GetInstance().GetAllData(param, null, null, null, null, false);
            if (menu == null || menu.getRowCount() <= 0 || StringUtil.isNull(menuId = menu.getRows()[0].get(DaoMenu.COLUMN_ID).toString()).booleanValue()) continue;
            HashMap<String, ParamBean> roleMenu = new HashMap<String, ParamBean>();
            roleMenu.put("role_id", new ParamBean(currentRoleId));
            roleMenu.put("menu_id", new ParamBean(menuId));
            roleMenu.put("create_time", new ParamBean(StringUtil.getDateNow(), 2));
            roleMenu.put("creator", new ParamBean(this.getStringByParam(map, "userId")));
            roleMenuList.add(roleMenu);
        }
        try {
            ServiceMenu.GetInstance().setSysRoleMenu(currentRoleId, roleMenuList);
            result = ResponseUtil.CreateResponseMap(true, "\u8bbe\u7f6e\u89d2\u8272\u83dc\u5355\u6743\u9650\u6210\u529f");
        }
        catch (Exception ex) {
            result = ResponseUtil.CreateResponseMap(false, "\u8bbe\u7f6e\u89d2\u8272\u83dc\u5355\u6743\u9650\u53d1\u751f\u5f02\u5e38");
            LogManager.LogError(logger, "\u89d2\u8272\u83dc\u5355\u6743\u9650\u5f02\u5e38" + ex.getMessage());
        }
        this.renderJson(channel, result, request);
    }

    @IHttpRequest(Url="set_role_action", Method="POST")
    public void SetSysRoleAction(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> result;
        String[] actionCodeArray;
        String currentRoleId = this.getStringByParam(map, "currentRoleId");
        ArrayList<Map<String, ParamBean>> roleActionList = new ArrayList<Map<String, ParamBean>>();
        for (String actionCode : actionCodeArray = (String[])this.getArrayByParam(map, "actionCodeArray", TypeUtil.STRING_ARRAY_TYPE)) {
            if (StringUtil.isNull(actionCode).booleanValue()) continue;
            HashMap<String, ParamBean> roleAction = new HashMap<String, ParamBean>();
            roleAction.put("role_id", new ParamBean(currentRoleId));
            roleAction.put("action_code", new ParamBean(actionCode));
            roleAction.put("create_time", new ParamBean(StringUtil.getDateNow(), 2));
            roleAction.put("creator", new ParamBean(this.getStringByParam(map, "userId")));
            roleActionList.add(roleAction);
        }
        try {
            ServiceAction.GetInstance().setSysRoleAction(currentRoleId, roleActionList);
            result = ResponseUtil.CreateResponseMap(true, "\u8bbe\u7f6e\u89d2\u8272\u529f\u80fd\u6743\u9650\u6210\u529f");
        }
        catch (Exception ex) {
            result = ResponseUtil.CreateResponseMap(false, "\u8bbe\u7f6e\u89d2\u8272\u529f\u80fd\u6743\u9650\u53d1\u751f\u5f02\u5e38");
            LogManager.LogError(logger, "\u89d2\u8272\u529f\u80fd\u6743\u9650\u5f02\u5e38" + ex.getMessage());
        }
        this.renderJson(channel, result, request);
    }

    @IHttpRequest(Url="set_role_message", Method="POST")
    public void SetSysRoleMessage(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, Object> result;
        String[] messageIdArray;
        String currentRoleId = this.getStringByParam(map, "currentRoleId");
        ArrayList<Map<String, ParamBean>> roleMessageList = new ArrayList<Map<String, ParamBean>>();
        for (String messageId : messageIdArray = (String[])this.getArrayByParam(map, "messageIdArray", TypeUtil.STRING_ARRAY_TYPE)) {
            if (StringUtil.isNull(messageId).booleanValue()) continue;
            HashMap<String, ParamBean> messageType = new HashMap<String, ParamBean>();
            messageType.put("role_id", new ParamBean(currentRoleId));
            messageType.put("type_id", new ParamBean(messageId));
            messageType.put("create_time", new ParamBean(StringUtil.getDateNow(), 2));
            messageType.put("creator", new ParamBean(this.getStringByParam(map, "userId")));
            roleMessageList.add(messageType);
        }
        try {
            ServiceMessage.GetInstance().setSysRoleMessage(currentRoleId, roleMessageList);
            result = ResponseUtil.CreateResponseMap(true, "\u8bbe\u7f6e\u89d2\u8272\u6d88\u606f\u6743\u9650\u6210\u529f");
        }
        catch (Exception ex) {
            result = ResponseUtil.CreateResponseMap(false, "\u8bbe\u7f6e\u89d2\u8272\u6d88\u606f\u6743\u9650\u53d1\u751f\u5f02\u5e38");
            LogManager.LogError(logger, "\u89d2\u8272\u6d88\u606f\u6743\u9650\u5f02\u5e38" + ex.getMessage());
        }
        this.renderJson(channel, result, request);
    }
}

