/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.services.sys.http;

import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.httpserver.httpservice.BaseHttpService;
import com.simba.common.common.httpserver.httpservice.IHttpRequest;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.wcsclient.common.ConstManager;
import com.simba.server.wcsclient.models.DaoMessageUser;
import com.simba.server.wcsclient.services.utils.ResponseUtil;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class MessageUserHttpService
extends BaseHttpService {
    public static final String NAME = "message_user";

    @IHttpRequest(Url="get_user_message", Method="POST")
    public void GetUserMessage(Channel channel, Map<String, Object> content, HttpRequest request) {
        int pageSize = this.getIntegerByParam(content, "pageSize", 25);
        int currentPage = this.getIntegerByParam(content, "currentPage", 1);
        String userId = this.getStringByParam(content, "userId");
        if (StringUtil.isNull(userId).booleanValue()) {
            Map<String, Object> responseParam = ResponseUtil.CreateResponseMap(false, "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a!");
            this.renderJson(channel, responseParam, request);
            return;
        }
        HashMap<String, ParamBean> map = new HashMap<String, ParamBean>();
        map.put("user_id", new ParamBean(userId));
        int count = DaoMessageUser.GetInstance().GetCountByCondition(map, null, null, null);
        DbPageData data = DaoMessageUser.GetInstance().GetDataByPage(pageSize, currentPage, count, map, null, null, null, null, false);
        Map<String, Object> responseParam = ResponseUtil.CreateResponseMap(true, "\u83b7\u53d6\u7528\u6237\u6d88\u606f\u6210\u529f!");
        responseParam.put("data", data);
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="update_message_status", Method="POST")
    public void UpdateMessageStatus(Channel channel, Map<String, Object> content, HttpRequest request) {
        String messageId = this.getStringByParam(content, "messageId");
        if (StringUtil.isNull(messageId).booleanValue()) {
            Map<String, Object> responseParam = ResponseUtil.CreateResponseMap(false, "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a!");
            this.renderJson(channel, responseParam, request);
            return;
        }
        HashMap<String, ParamBean> bean = new HashMap<String, ParamBean>();
        bean.put("mes_status", new ParamBean(ConstManager.CONST_VALUE_MESSAGE_STATUS_READ));
        int result = DaoMessageUser.GetInstance().UpdateDataById(bean, messageId);
        Map<String, Object> responseParam = result > 0 ? ResponseUtil.CreateResponseMap(true, "\u6d88\u606f\u72b6\u6001\u66f4\u65b0\u6210\u529f!") : ResponseUtil.CreateResponseMap(false, "\u6d88\u606f\u72b6\u6001\u66f4\u65b0\u5931\u8d25!");
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="get_no_read_count", Method="POST")
    public void GetNoReadCount(Channel channel, Map<String, Object> content, HttpRequest request) {
        String userId = this.getStringByParam(content, "userId");
        if (StringUtil.isNull(userId).booleanValue()) {
            Map<String, Object> responseParam = ResponseUtil.CreateResponseMap(false, "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a!");
            this.renderJson(channel, responseParam, request);
            return;
        }
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put("mes_status", new ParamBean(ConstManager.CONST_VALUE_MESSAGE_STATUS_NOREAD));
        maps.put("user_id", new ParamBean(userId));
        int noRead = DaoMessageUser.GetInstance().GetCountByCondition(maps, null, null, null);
        Map<String, Object> responseParam = ResponseUtil.CreateResponseMap(true, "\u672a\u8bfb\u4fe1\u606f\u6570\u91cf\u83b7\u53d6\u6210\u529f!");
        responseParam.put("noRead", noRead);
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="truncation", Method="POST")
    public void TruncationMessage(Channel channel, Map<String, Object> content, HttpRequest request) {
        String userId = this.getStringByParam(content, "userId");
        if (StringUtil.isNull(userId).booleanValue()) {
            Map<String, Object> responseParam = ResponseUtil.CreateResponseMap(false, "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a!");
            this.renderJson(channel, responseParam, request);
            return;
        }
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put("user_id", new ParamBean(userId));
        DaoMessageUser.GetInstance().DeleteDataInfoByCondition(maps, null, null, null, null);
        int row = DaoMessageUser.GetInstance().GetCountByCondition(maps, null, null, null);
        Map<String, Object> responseParam = row == 0 ? ResponseUtil.CreateResponseMap(true, "\u6e05\u7a7a\u6210\u529f!") : ResponseUtil.CreateResponseMap(false, "\u6e05\u7a7a\u5931\u8d25!");
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="delete_message_by_id", Method="POST")
    public void DeleteDataInfoById(Channel channel, Map<String, Object> content, HttpRequest request) {
        String messageId = this.getStringByParam(content, "messageId");
        if (StringUtil.isNull(messageId).booleanValue()) {
            Map<String, Object> responseParam = ResponseUtil.CreateResponseMap(false, "\u6d88\u606fId\u4e0d\u80fd\u4e3a\u7a7a!");
            this.renderJson(channel, responseParam, request);
            return;
        }
        int row = DaoMessageUser.GetInstance().DeleteDataInfoById(messageId);
        Map<String, Object> responseParam = row > 0 ? ResponseUtil.CreateResponseMap(true, "\u5220\u9664\u6210\u529f!") : ResponseUtil.CreateResponseMap(false, "\u5220\u9664\u5931\u8d25!");
        this.renderJson(channel, responseParam, request);
    }
}

