/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.models;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.dao.DaoBaseClass;
import com.simba.common.common.database.dao.IDaoBaseClass;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.wcsclient.common.ConstManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DaoUser
extends DaoBaseClass
implements IDaoBaseClass {
    public static final String DATABASE_TABLE_NAME = "tb_sys_users";
    public static final String COLUMN_USER_ID = "user_id";
    public static final String COLUMN_USER_NAME = "user_name";
    public static final String COLUMN_USER_PASSWORD = "user_password";
    public static final String COLUMN_USER_GROUP = "user_group";
    public static final String COLUMN_CREATE_TIME = "create_time";
    public static final String COLUMN_LAST_LOGIN_TIME = "last_login_time";
    public static final String COLUMN_DISCRIPTION = "discription";
    public static final String COLUMN_USER_PHONE = "user_phone";
    public static final String COLUMN_USER_SEX = "user_sex";
    public static final String COLUMN_USER_POSITION = "user_position";
    public static final String COLUMN_STATUS = "user_status";
    private static DaoUser instance;

    public static DaoUser GetInstance() {
        if (instance == null) {
            instance = new DaoUser();
        }
        return instance;
    }

    @Override
    public String GetDataBaseName() {
        return DATABASE_TABLE_NAME;
    }

    @Override
    public String[] GetDateColumn() {
        return new String[]{COLUMN_CREATE_TIME, COLUMN_LAST_LOGIN_TIME};
    }

    @Override
    public String[] GetKeywordsColumn() {
        return new String[]{COLUMN_USER_ID, COLUMN_USER_NAME, COLUMN_USER_PHONE};
    }

    @Override
    public String[] GetOrderColumn() {
        return null;
    }

    @Override
    public int CreateTable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{COLUMN_ID, "int", "11", "NOT NULL"});
        list.add(new String[]{COLUMN_USER_ID, "varchar", "10", "NOT NULL"});
        list.add(new String[]{COLUMN_USER_NAME, "varchar", "20", "NOT NULL"});
        list.add(new String[]{COLUMN_USER_PASSWORD, "varchar", "50", "NOT NULL"});
        list.add(new String[]{COLUMN_USER_GROUP, "int", "11", "DEFAULT 0"});
        list.add(new String[]{COLUMN_CREATE_TIME, "datetime", "", "DEFAULT NULL"});
        list.add(new String[]{COLUMN_LAST_LOGIN_TIME, "datetime", "", "DEFAULT NULL"});
        list.add(new String[]{COLUMN_DISCRIPTION, "varchar", "100", "DEFAULT NULL"});
        list.add(new String[]{COLUMN_USER_PHONE, "varchar", "11", "DEFAULT NULL"});
        list.add(new String[]{COLUMN_USER_SEX, "varchar", "11", "DEFAULT NULL"});
        list.add(new String[]{COLUMN_USER_POSITION, "varchar", "20", "DEFAULT NULL"});
        list.add(new String[]{COLUMN_STATUS, "varchar", "11", "DEFAULT NULL"});
        return this.dbHelper.CreateTable(DATABASE_TABLE_NAME, list, null);
    }

    @Override
    public void CreateDefaultData() {
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put(COLUMN_ID, new ParamBean(1));
        maps.put(COLUMN_USER_ID, new ParamBean("10001"));
        maps.put(COLUMN_USER_NAME, new ParamBean("admin"));
        maps.put(COLUMN_USER_PASSWORD, new ParamBean("111111"));
        maps.put(COLUMN_DISCRIPTION, new ParamBean("\u7ba1\u7406\u5458"));
        maps.put(COLUMN_STATUS, new ParamBean(ConstManager.CONST_VALUE_USER_STATUS_VALID));
        String time = StringUtil.getDateNow();
        maps.put(COLUMN_CREATE_TIME, new ParamBean(time, 2));
        maps.put(COLUMN_LAST_LOGIN_TIME, new ParamBean(time, 2));
        this.dbHelper.AddData(DATABASE_TABLE_NAME, maps, true);
    }

    @Override
    public int AddNewDataInfo(Map<String, ParamBean> maps) {
        if (maps == null || !maps.containsKey(COLUMN_USER_ID)) {
            return -2;
        }
        HashMap<String, ParamBean> pa = new HashMap<String, ParamBean>();
        pa.put(COLUMN_USER_ID, maps.get(COLUMN_USER_ID));
        int count = this.GetCountByCondition(pa, null, null, null);
        if (count > 0) {
            return -1;
        }
        String time = StringUtil.getDateNow();
        maps.put(COLUMN_CREATE_TIME, new ParamBean(time, 2));
        maps.put(COLUMN_LAST_LOGIN_TIME, new ParamBean(time, 2));
        maps.put(COLUMN_USER_PASSWORD, new ParamBean("111111"));
        return this.dbHelper.AddData(DATABASE_TABLE_NAME, maps, false);
    }

    @Override
    public int UpdateDataById(Map<String, ParamBean> maps, String value) {
        if (maps.containsKey(COLUMN_USER_ID)) {
            HashMap<String, ParamBean> pa = new HashMap<String, ParamBean>();
            pa.put(COLUMN_USER_ID, maps.get(COLUMN_USER_ID));
            String condition = COLUMN_ID + "!=" + value;
            int count = this.GetCountByCondition(pa, null, condition, null);
            if (count > 0) {
                return -1;
            }
        }
        return super.UpdateDataById(maps, value);
    }
}

