/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.common;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.GlobalParam;
import com.simba.server.wcsclient.models.DaoMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.log4j.Logger;

public abstract class BaseMenuManager {
    private static final String MENU = "Menu";
    private static final Logger logger = Logger.getLogger(BaseMenuManager.class);
    private List<Map<String, ParamBean>> menuMap = new ArrayList<Map<String, ParamBean>>();

    protected BaseMenuManager() {
    }

    public void checkAndInitMenu() {
        Result menus = DaoMenu.GetInstance().GetAllData(null, null, null, null, null, false);
        if (menus == null || menus.getRowCount() <= 0) {
            this.init();
        }
    }

    private void init() {
        this.initMenuDatabase();
    }

    private void initMenuDatabase() {
        this.initBaseMenu();
        DaoMenu.GetInstance().BatchAddData(this.menuMap);
    }

    protected void createItem(String name, String header, String iconPath, String parentName, boolean isClick, boolean isAutoCreateClick, boolean isAddExpander) {
        parentName = StringUtil.isNull(parentName) != false ? "root" : MENU + parentName;
        String menu_name = MENU + name;
        HashMap<String, ParamBean> bean = new HashMap<String, ParamBean>();
        bean.put("menu_id", new ParamBean(menu_name));
        bean.put("menu_name", new ParamBean(header));
        bean.put("icon", new ParamBean(iconPath == null ? "" : iconPath));
        bean.put("parent_menu_id", new ParamBean(parentName));
        bean.put("is_click", new ParamBean(isClick));
        bean.put("is_auto_create_click", new ParamBean(isAutoCreateClick));
        bean.put("is_add_expander", new ParamBean(isAddExpander));
        this.menuMap.add(bean);
        GlobalParam.permissions.createModule(name, header);
    }

    private void initBaseMenu() {
        this.createItem("Begin", "\u5f00\u59cb", null, null, false, false, false);
        this.createItem("MainLog", "\u7cfb\u7edf\u65e5\u5fd7", "MainLog.png", "Begin", true, true, false);
        this.createItem("Setting", "\u8bbe\u7f6e", "setting.ico", "Begin", false, false, false);
        this.createItem("OpenType", "\u5185\u5bb9\u6253\u5f00\u65b9\u5f0f", "show_type.ico", "Setting", false, false, false);
        this.createItem("OpenWindow", "\u65b0\u7a97\u53e3", "show_window.ico", "OpenType", true, false, false);
        this.createItem("OpenPanel", "\u9762   \u677f", "show_panel.ico", "OpenType", true, false, false);
        this.createItem("RankStyle", "\u7a97\u53e3\u6392\u5217\u65b9\u5f0f", "Window_Rank.ico", "Setting", false, false, false);
        this.createItem("OrderRank", "\u987a\u5e8f\u6392\u5217", "Windows_Top_Left.ico", "RankStyle", true, false, false);
        this.createItem("CenterRank", "\u4e2d\u95f4\u91cd\u53e0", "Window_Center.ico", "RankStyle", true, false, false);
        this.createItem("Close", "\u9000\u51fa", "close_item.ico", "Begin", true, false, false);
        this.createItem("Monitor", "\u76d1\u63a7", null, null, false, false, true);
        this.createItem("ServerInfo", "\u5b9e\u65f6\u6d88\u606f", "ServerInfo.png", "Monitor", true, true, true);
        this.createItem("Machine", "\u76d1\u63a7\u4e2d\u5fc3", "ServerInfo.png", "Monitor", true, true, true);
        this.createItem("SortControl", "\u63a7\u5236\u4e2d\u5fc3", "ServerInfo.png", "Monitor", true, true, true);
        this.createItem("NetWork", "\u7f51\u7edc", null, null, false, false, false);
        this.createItem("LinkList", "\u8fde\u63a5\u5217\u8868", "SortInfo.png", "NetWork", true, true, false);
        this.createItem("LinkManage", "\u8fde\u63a5\u7ba1\u7406", "SortInfo.png", "NetWork", true, true, false);
        this.initMenu();
        this.createItem("UserManage", "\u7cfb\u7edf\u7ba1\u7406", null, null, false, false, true);
        this.createItem("Users", "\u64cd\u4f5c\u5458\u7ba1\u7406", "", "UserManage", true, true, true);
        this.createItem("Roles", "\u89d2\u8272\u7ba1\u7406", "", "UserManage", true, true, true);
        this.createItem("MessageManage", "\u6d88\u606f", "", "UserManage", false, false, false);
        this.createItem("Message", "\u6d88\u606f\u7ba1\u7406", "", "MessageManage", true, true, false);
        this.createItem("MessageType", "\u7c7b\u578b\u7ba1\u7406", "", "MessageManage", true, true, false);
        this.createItem("About", "\u5173\u4e8e\u6211\u4eec", null, null, false, false, true);
        this.createItem("AboutMe", "\u5173\u4e8e\u6211\u4eec", "", "About", true, true, true);
        this.createItem("Service", "\u552e\u540e\u670d\u52a1", "", "About", true, true, true);
    }

    public abstract void initMenu();
}

