/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.common;

import com.simba.common.common.database.dao.IDaoBaseClass;
import com.simba.common.common.log.LogManager;
import com.simba.server.wcsclient.common.BaseMenuManager;
import com.simba.server.wcsclient.models.DaoAction;
import com.simba.server.wcsclient.models.DaoAnnex;
import com.simba.server.wcsclient.models.DaoConst;
import com.simba.server.wcsclient.models.DaoLicense;
import com.simba.server.wcsclient.models.DaoLink;
import com.simba.server.wcsclient.models.DaoLoginLog;
import com.simba.server.wcsclient.models.DaoMenu;
import com.simba.server.wcsclient.models.DaoMessage;
import com.simba.server.wcsclient.models.DaoMessageType;
import com.simba.server.wcsclient.models.DaoMessageUser;
import com.simba.server.wcsclient.models.DaoMonitor;
import com.simba.server.wcsclient.models.DaoOperateHis;
import com.simba.server.wcsclient.models.DaoRole;
import com.simba.server.wcsclient.models.DaoRoleAction;
import com.simba.server.wcsclient.models.DaoRoleMenu;
import com.simba.server.wcsclient.models.DaoRoleMessageType;
import com.simba.server.wcsclient.models.DaoRoleUser;
import com.simba.server.wcsclient.models.DaoUser;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseDatabaseManager {
    private Map<String, IDaoBaseClass> databases = new HashMap<String, IDaoBaseClass>();
    private static final Logger logger = Logger.getLogger(BaseMenuManager.class);

    protected BaseDatabaseManager() {
    }

    private void initDefaultDatabase() {
        this.addDatabase("User", DaoUser.GetInstance());
        this.addDatabase("License", DaoLicense.GetInstance());
        this.addDatabase("Action", DaoAction.GetInstance());
        this.addDatabase("Annex", DaoAnnex.GetInstance());
        this.addDatabase("Const", DaoConst.GetInstance());
        this.addDatabase("ink", DaoLink.GetInstance());
        this.addDatabase("LoginLog", DaoLoginLog.GetInstance());
        this.addDatabase("Menu", DaoMenu.GetInstance());
        this.addDatabase("Message", DaoMessage.GetInstance());
        this.addDatabase("MessageType", DaoMessageType.GetInstance());
        this.addDatabase("MessageUser", DaoMessageUser.GetInstance());
        this.addDatabase("Monitor", DaoMonitor.GetInstance());
        this.addDatabase("OperateHis", DaoOperateHis.GetInstance());
        this.addDatabase("Role", DaoRole.GetInstance());
        this.addDatabase("RoleAction", DaoRoleAction.GetInstance());
        this.addDatabase("RoleMenu", DaoRoleMenu.GetInstance());
        this.addDatabase("RoleMessageType", DaoRoleMessageType.GetInstance());
        this.addDatabase("RoleUser", DaoRoleUser.GetInstance());
    }

    public void init() {
        this.initDefaultDatabase();
        this.initDatabase();
    }

    public boolean addDatabase(String key, IDaoBaseClass database) {
        if (this.databases.containsKey(key)) {
            LogManager.LogError(logger, "Init Databases Error, The " + key + "is Already exit");
            System.exit(0);
            return false;
        }
        this.databases.put(key, database);
        return true;
    }

    public IDaoBaseClass getDatabase(String key) {
        if (this.databases.containsKey(key)) {
            return this.databases.get(key);
        }
        return null;
    }

    public abstract void initDatabase();
}

