/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.actions;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.server.wcsclient.models.DaoMenu;
import com.simba.server.wcsclient.models.DaoRoleMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;

public class ServiceMenu {
    private static ServiceMenu instance;

    public static ServiceMenu GetInstance() {
        if (instance == null) {
            instance = new ServiceMenu();
        }
        return instance;
    }

    public List<Map<String, Object>> listSysRoleMenu(Map<String, Object> param) {
        Result result = DaoMenu.GetInstance().listSysRoleMenu(param);
        if (result == null) {
            return new ArrayList<Map<String, Object>>();
        }
        List<Map<String, Object>> sysMenuList = Arrays.asList(result.getRows());
        if (sysMenuList.size() > 0) {
            ArrayList<Map<String, Object>> newMenuList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> startMenu = new HashMap<String, Object>();
            startMenu.put("menu_id", "root");
            this.initMenuList(startMenu, sysMenuList, newMenuList);
            return newMenuList;
        }
        return sysMenuList;
    }

    private void initMenuList(Map<String, Object> startMenu, List<Map<String, Object>> oldMenuList, List<Map<String, Object>> newMenuList) {
        String startId = startMenu.get("menu_id").toString();
        ArrayList<Map<String, Object>> tmpMenuList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> menu : oldMenuList) {
            if (menu.get("parent_menu_id") == null || !menu.get("parent_menu_id").toString().equals(startId)) continue;
            tmpMenuList.add(menu);
        }
        if (!startMenu.get("menu_id").toString().equals("root")) {
            newMenuList.add(startMenu);
        }
        if (tmpMenuList.size() > 0) {
            this.orderMenuList(tmpMenuList);
            for (Map<String, Object> tmpMenu : tmpMenuList) {
                this.initMenuList(tmpMenu, oldMenuList, newMenuList);
            }
        }
    }

    private void orderMenuList(List<Map<String, Object>> menuList) {
        if (menuList != null && menuList.size() > 0) {
            for (int i = 0; i < menuList.size(); ++i) {
                for (int j = 0; j < menuList.size() - (i + 1); ++j) {
                    int order2;
                    Map<String, Object> menu1 = menuList.get(j);
                    Map<String, Object> menu2 = menuList.get(j + 1);
                    int order1 = Integer.parseInt(menu1.get("show_order").toString());
                    if (order1 <= (order2 = Integer.parseInt(menu2.get("show_order").toString()))) continue;
                    HashMap dr = new HashMap();
                    menuList.set(j, menu2);
                    menuList.set(j + 1, menu1);
                }
            }
        }
    }

    public List<Map<String, Object>> listSysMenuRoleTreeInfo(Map<String, Object> param) {
        Result result = DaoMenu.GetInstance().listSysMenuRoleInfo(param);
        if (result == null) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> menuTreeList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> sysMenuList = Arrays.asList(result.getRows());
        if (sysMenuList.size() > 0) {
            HashMap<String, Object> menu = new HashMap<String, Object>();
            menu.put("menu_id", "root");
            menu.put("text", "\u6b23\u5df4WCS\u7cfb\u7edf");
            menu.put("iconCls", "icon-computer");
            this.initMenuList(menu, sysMenuList);
            menuTreeList.add(menu);
        }
        return menuTreeList;
    }

    private void initMenuList(Map<String, Object> startMenu, List<Map<String, Object>> menuList) {
        String startId = startMenu.get("menu_id").toString();
        ArrayList<Map<String, Object>> tmpMenuList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> menu : menuList) {
            String parentMenuId = menu.get("parent_menu_id").toString();
            if (parentMenuId == null || !parentMenuId.equals(startId)) continue;
            tmpMenuList.add(menu);
        }
        if (tmpMenuList.size() > 0) {
            this.orderedMenuList(tmpMenuList);
            for (Map<String, Object> tmpMenu : tmpMenuList) {
                this.initMenuList(tmpMenu, menuList);
            }
            startMenu.put("children", this.getChildrenList(tmpMenuList));
        }
    }

    private void orderedMenuList(List<Map<String, Object>> menuList) {
        if (menuList != null && menuList.size() > 0) {
            for (int i = 0; i < menuList.size(); ++i) {
                for (int j = 0; j < menuList.size() - (i + 1); ++j) {
                    int order2;
                    Map<String, Object> menu1 = menuList.get(j);
                    Map<String, Object> menu2 = menuList.get(j + 1);
                    int order1 = Integer.parseInt(menu1.get("show_order").toString());
                    if (order1 <= (order2 = Integer.parseInt(menu2.get("show_order").toString()))) continue;
                    HashMap dr = new HashMap();
                    menuList.set(j, menu2);
                    menuList.set(j + 1, menu1);
                }
            }
        }
    }

    private List<Map<String, Object>> getChildrenList(List<Map<String, Object>> menuList) {
        ArrayList<Map<String, Object>> childrenList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> menu : menuList) {
            HashMap<String, Object> child = new HashMap<String, Object>();
            child.put("menu_id", menu.get("menu_id"));
            child.put("text", menu.get("menu_name"));
            long roleCount = (Long)menu.get("role_count");
            if (!(roleCount <= 0L || menu.containsKey("children") && menu.get("children") != null)) {
                child.put("checked", true);
            }
            child.put("children", menu.getOrDefault("children", null));
            childrenList.add(child);
        }
        return childrenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSysRoleMenu(String roleId, List<Map<String, ParamBean>> roleMenuList) {
        ServiceMenu serviceMenu = this;
        synchronized (serviceMenu) {
            HashMap<String, ParamBean> param = new HashMap<String, ParamBean>();
            param.put("roleId", new ParamBean(roleId));
            DaoRoleMenu.GetInstance().deleteSysRoleMenuByRoleId(param);
            if (roleMenuList != null && roleMenuList.size() > 0) {
                DaoRoleMenu.GetInstance().BatchAddData(roleMenuList);
            }
        }
    }
}

