/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.tables.daos.Report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simba.common.common.database.bean.DateBean;
import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.dao.DaoBaseClass;
import com.simba.common.common.database.dao.IDaoBaseClass;
import com.simba.common.common.utils.StringUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DaoPlatRate
extends DaoBaseClass
implements IDaoBaseClass {
    public static final String DATABASE_TABLE_NAME = "tt_packet_off_info";
    public static final String COLUMN_SEARCH_TIME = "packetOffTime";
    public static final String COLUMN_PERIOD = "period";
    private Gson gson = new GsonBuilder().serializeNulls().create();
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DaoPlatRate instance;

    public static DaoPlatRate GetInstance() {
        if (instance == null) {
            instance = new DaoPlatRate();
        }
        return instance;
    }

    @Override
    public DbPageData GetDataByPage(int pageSize, int currentPage, int count, Map<String, ParamBean> maps, String keywords, String[] ignoreKeys, String group, String having, boolean isOrderDesc) {
        if (maps == null) {
            maps = new HashMap<String, ParamBean>();
        }
        int period = 15;
        if (maps.containsKey(COLUMN_PERIOD)) {
            period = Integer.parseInt(maps.get(COLUMN_PERIOD).getValue().toString());
            maps.remove(COLUMN_PERIOD);
        }
        if (!maps.containsKey(COLUMN_SEARCH_TIME)) {
            SimpleDateFormat formatB = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            SimpleDateFormat formatE = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            maps.put(COLUMN_SEARCH_TIME, new ParamBean(new DateBean(formatB.format(new Date()), formatE.format(new Date())), 2));
        } else {
            ParamBean paramBean = maps.get(COLUMN_SEARCH_TIME);
            if (paramBean.getValue() != null) {
                DateBean dateBean = (DateBean)this.gson.fromJson(this.gson.toJson(paramBean.getValue()), new TypeToken<DateBean>(){}.getType());
                paramBean.setValue(dateBean);
            }
        }
        DbPageData table = this.dbHelper.GetDataPage(this.GetDataBaseName(), 0, 1, count, "DATE_FORMAT(packetOffTime,'%Y-%m-%d %H:%i:00') secound,platId, count(*) as num", maps, this.GetKeywordsColumn(), keywords, null, false, null, "secound,platId", null, null);
        if (table == null || table.getPageData() == null) {
            return null;
        }
        DateBean bean = (DateBean)maps.get(COLUMN_SEARCH_TIME).getValue();
        long totalMinutes = DaoPlatRate.getTimeDifference(bean.getBeginDate(), bean.getEndDate());
        if (totalMinutes > 1440L) {
            table.setPageData(null);
            return table;
        }
        try {
            HashMap<String, Map<String, Integer>> data = new HashMap<String, Map<String, Integer>>();
            for (Map row : table.getPageData()) {
                int num;
                int i;
                Map<String, Integer> platData;
                String platId = row.get("platId").toString();
                if (StringUtil.isNull(platId).booleanValue()) continue;
                if (data.containsKey(platId)) {
                    platData = (Map)data.get(platId);
                    Date nowDate = this.format.parse(row.get("secound").toString());
                    int itemNum = Integer.parseInt(row.get("num").toString());
                    for (i = 0; i < period; ++i) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(nowDate);
                        calendar.add(12, -period);
                        calendar.add(12, i);
                        String time = this.format.format(calendar.getTime());
                        if (!platData.containsKey(time)) continue;
                        num = (Integer)platData.get(time);
                        platData.put(this.format.format(calendar.getTime()), num += itemNum);
                    }
                    continue;
                }
                platData = new LinkedHashMap();
                platData.put("platId", (Integer)((Object)platId));
                Date beginTime = this.format.parse(bean.getBeginDate());
                Calendar calendar = Calendar.getInstance();
                i = 0;
                while ((long)i < totalMinutes) {
                    calendar.setTime(beginTime);
                    calendar.add(12, i);
                    Date dateBegin = calendar.getTime();
                    calendar.add(12, period);
                    Date dateEnd = calendar.getTime();
                    num = 0;
                    Date nowDate = this.format.parse(row.get("secound").toString());
                    if ((nowDate.compareTo(dateBegin) == 0 || nowDate.after(dateBegin)) && (nowDate.compareTo(dateEnd) == 0 || nowDate.before(dateEnd))) {
                        num += Integer.parseInt(row.get("num").toString());
                    }
                    platData.put(this.format.format(dateBegin), num);
                    ++i;
                }
                data.put(platId, platData);
            }
            table.setPageData(data.values().toArray(new Map[0]));
        }
        catch (Exception e) {
            table.setPageData(null);
        }
        return table;
    }

    @Override
    public int GetCountByCondition(Map<String, ParamBean> maps, String keywords, String condition, String[] ignoreKeys) {
        ParamBean paramBean;
        if (maps == null) {
            return 1440;
        }
        if (maps.containsKey(COLUMN_SEARCH_TIME) && (paramBean = maps.get(COLUMN_SEARCH_TIME)).getValue() != null) {
            DateBean dateBean = (DateBean)this.gson.fromJson(this.gson.toJson(paramBean.getValue()), new TypeToken<DateBean>(){}.getType());
            return (int)DaoPlatRate.getTimeDifference(dateBean.getBeginDate(), dateBean.getEndDate());
        }
        if (maps.containsKey(COLUMN_PERIOD)) {
            maps.remove(COLUMN_PERIOD);
        }
        return 1440;
    }

    private static long getTimeDifference(String time1, String time2) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date beginTime = format.parse(time1);
            Date endTime = format.parse(time2);
            long between = (endTime.getTime() - beginTime.getTime()) / 1000L;
            long minute = between / 60L;
            if (between % 60L != 0L) {
                ++minute;
            }
            return minute;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    @Override
    public String GetDataBaseName() {
        return DATABASE_TABLE_NAME;
    }

    @Override
    public String[] GetKeywordsColumn() {
        return new String[0];
    }

    @Override
    public String[] GetOrderColumn() {
        return new String[0];
    }
}

