/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.tables.daos.Report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simba.common.common.database.bean.DateBean;
import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.dao.DaoBaseClass;
import com.simba.common.common.database.dao.IDaoBaseClass;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DaoMaxSortByTime
extends DaoBaseClass
implements IDaoBaseClass {
    public static final String DATABASE_TABLE_NAME = "tt_packet_off_info";
    public static final String COLUMN_TIME_BEGIN = "timeBegin";
    public static final String COLUMN_TIME_END = "timeEnd";
    public static final String COLUMN_BARCODE_NUM = "barcodeNum";
    public static final String COLUMN_SEARCH_TIME = "packetOffTime";
    public static final String COLUMN_PERIOD = "period";
    public static final String COLUMN_PLAT_ID = "platId";
    private Gson gson = new GsonBuilder().serializeNulls().create();
    private static DaoMaxSortByTime instance;

    public static DaoMaxSortByTime GetInstance() {
        if (instance == null) {
            instance = new DaoMaxSortByTime();
        }
        return instance;
    }

    @Override
    public DbPageData GetDataByPage(int pageSize, int currentPage, int count, Map<String, ParamBean> maps, String keywords, String[] ignoreKeys, String group, String having, boolean isOrderDesc) {
        if (maps == null) {
            maps = new HashMap<String, ParamBean>();
        }
        int period = 15;
        if (maps.containsKey(COLUMN_PERIOD)) {
            period = Integer.parseInt(maps.get(COLUMN_PERIOD).getValue().toString());
            maps.remove(COLUMN_PERIOD);
        }
        if (!maps.containsKey(COLUMN_SEARCH_TIME)) {
            SimpleDateFormat formatB = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            SimpleDateFormat formatE = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            maps.put(COLUMN_SEARCH_TIME, new ParamBean(new DateBean(formatB.format(new Date()), formatE.format(new Date())), 2));
        } else {
            ParamBean paramBean = maps.get(COLUMN_SEARCH_TIME);
            if (paramBean.getValue() != null) {
                DateBean dateBean = (DateBean)this.gson.fromJson(this.gson.toJson(paramBean.getValue()), new TypeToken<DateBean>(){}.getType());
                paramBean.setValue(dateBean);
            }
        }
        DbPageData table = this.dbHelper.GetDataPage(this.GetDataBaseName(), 0, 1, count, "DATE_FORMAT(packetOffTime,'%Y-%m-%d %H:%i:00') secound, count(*) as num", maps, this.GetKeywordsColumn(), keywords, null, false, null, "secound", null, null);
        if (table == null) {
            return table;
        }
        DateBean bean = (DateBean)maps.get(COLUMN_SEARCH_TIME).getValue();
        long totalMinutes = DaoMaxSortByTime.getTimeDifference(bean.getBeginDate(), bean.getEndDate());
        if (totalMinutes > 1440L) {
            table.setPageData(null);
            return table;
        }
        try {
            ArrayList data = new ArrayList();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date beginTime = format.parse(bean.getBeginDate());
            Calendar calendar = Calendar.getInstance();
            int i = 0;
            while ((long)i < totalMinutes) {
                calendar.setTime(beginTime);
                calendar.add(12, i);
                Date dateBegin = calendar.getTime();
                calendar.add(12, period);
                Date dateEnd = calendar.getTime();
                int num = 0;
                if (table.getPageData() != null) {
                    for (Map rowData : table.getPageData()) {
                        Date nowDate = format.parse(rowData.get("secound").toString());
                        if (nowDate.compareTo(dateBegin) != 0 && !nowDate.after(dateBegin) || nowDate.compareTo(dateEnd) != 0 && !nowDate.before(dateEnd)) continue;
                        num += Integer.parseInt(rowData.get("num").toString());
                    }
                }
                HashMap<String, Object> datarow = new HashMap<String, Object>();
                datarow.put(COLUMN_TIME_BEGIN, format.format(dateBegin));
                datarow.put(COLUMN_TIME_END, format.format(dateEnd));
                datarow.put(COLUMN_BARCODE_NUM, num);
                data.add(datarow);
                ++i;
            }
            table.setPageData(data.toArray(new Map[0]));
        }
        catch (Exception e) {
            table.setPageData(null);
        }
        return table;
    }

    @Override
    public int GetCountByCondition(Map<String, ParamBean> maps, String keywords, String condition, String[] ignoreKeys) {
        ParamBean paramBean;
        if (maps == null) {
            return 1440;
        }
        if (maps.containsKey(COLUMN_SEARCH_TIME) && (paramBean = maps.get(COLUMN_SEARCH_TIME)).getValue() != null) {
            DateBean dateBean = (DateBean)this.gson.fromJson(this.gson.toJson(paramBean.getValue()), new TypeToken<DateBean>(){}.getType());
            return (int)DaoMaxSortByTime.getTimeDifference(dateBean.getBeginDate(), dateBean.getEndDate());
        }
        if (maps.containsKey(COLUMN_PERIOD)) {
            maps.remove(COLUMN_PERIOD);
        }
        return 1440;
    }

    private static long getTimeDifference(String time1, String time2) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date beginTime = format.parse(time1);
            Date endTime = format.parse(time2);
            long between = (endTime.getTime() - beginTime.getTime()) / 1000L;
            long minute = between / 60L;
            if (between % 60L != 0L) {
                ++minute;
            }
            return minute;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    @Override
    public String GetDataBaseName() {
        return DATABASE_TABLE_NAME;
    }

    @Override
    public String[] GetKeywordsColumn() {
        return new String[0];
    }

    @Override
    public String[] GetOrderColumn() {
        return new String[0];
    }
}

