/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.tables.daos.Report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simba.common.common.database.bean.DateBean;
import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.bean.TableBean;
import com.simba.common.common.database.bean.TableInfo;
import com.simba.common.common.database.dao.DaoBaseClass;
import com.simba.common.common.database.dao.IDaoBaseClass;
import java.util.Map;

public class DaoGeneralRate
extends DaoBaseClass
implements IDaoBaseClass {
    public static final String DATABASE_TABLE_NAME = "tt_packet_off_info";
    private Gson gson = new GsonBuilder().serializeNulls().create();
    private static DaoGeneralRate instance;

    public static DaoGeneralRate GetInstance() {
        if (instance == null) {
            instance = new DaoGeneralRate();
        }
        return instance;
    }

    @Override
    public DbPageData GetDataByPage(int pageSize, int currentPage, int count, Map<String, ParamBean> maps, String keywords, String[] ignoreKeys, String group, String having, boolean isOrderDesc) {
        String condition = "1=1";
        if (maps != null && maps.containsKey("packetOffTime")) {
            ParamBean paramBean = maps.get("packetOffTime");
            DateBean dateBean = null;
            if (paramBean.getValue() != null) {
                dateBean = (DateBean)this.gson.fromJson(this.gson.toJson(paramBean.getValue()), new TypeToken<DateBean>(){}.getType());
            }
            if (dateBean != null) {
                condition = "packetOffTime >= '" + dateBean.getBeginDate() + "' and packetOffTime <= '" + dateBean.getEndDate() + "'";
            }
        }
        String t1 = "(select errorCodePLC, count(*) as count from tt_packet_off_info WHERE " + condition + " GROUP BY errorCodePLC)";
        int totalCount = this.dbHelper.GetCount(DATABASE_TABLE_NAME, null, null, null, condition + "", null, null, null);
        String otherField = "round(t1.count/" + totalCount + "*100, 2) as percent";
        TableBean bean = new TableBean();
        TableInfo table1 = bean.addDatabase(t1, "t1", new String[]{bean.getField("errorCodePLC"), bean.getField("count")}, new String[]{otherField});
        TableInfo table2 = bean.addDatabase("tt_trash_type", "t2", new String[]{bean.getField("exceptionDesc")}, null);
        bean.addRelation(table1, "errorCodePLC", table2, "exceptionCode");
        return this.dbHelper.GetDataPage(bean, pageSize, currentPage, count, null, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public int GetCountByCondition(Map<String, ParamBean> maps, String keywords, String condition, String[] ignoreKeys) {
        return this.dbHelper.GetCount("tt_trash_type", null, null, null, null, null, null, null);
    }

    @Override
    public String GetDataBaseName() {
        return DATABASE_TABLE_NAME;
    }

    @Override
    public String[] GetKeywordsColumn() {
        return new String[0];
    }

    @Override
    public String[] GetOrderColumn() {
        return new String[0];
    }
}

