/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.monitor.managers;

import com.simba.common.business.CommonProtocolDefines;
import com.simba.common.business.FrameUtils;
import com.simba.common.common.frameserver.FrameChannelManager;
import com.simba.server.monitor.constants.MonitorConstants;
import org.jboss.netty.channel.Channel;

public class MonitorMessage {
    private static final int SYSTEM_STATUS_CONTROL_SIZE = 5;
    private static final int SPEED_UPDATE_SIZE = 6;
    private static final int SYNC_SLOT_SIZE = 5;
    private static final int SYNC_CAR_SIZE = 5;
    private static final int SYNC_SLOT_LOCK_SIZE = 9;
    private static final int SYNC_CAR_MODE_SIZE = 9;

    private MonitorMessage() {
    }

    public static MonitorMessage getInstance() {
        return MonitorMessageHolder.INSTANCE;
    }

    public byte[] CreateSystemControlReplayMessage(int systemStatus) {
        byte[] replyBuffer = new byte[5];
        int position = 0;
        byte[] header = CommonProtocolDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{22};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] systemControl = new byte[]{(byte)systemStatus};
        System.arraycopy(systemControl, 0, replyBuffer, position += command.length, systemControl.length);
        byte[] serialByte = new byte[]{1};
        System.arraycopy(serialByte, 0, replyBuffer, position += systemControl.length, serialByte.length);
        position += serialByte.length;
        return replyBuffer;
    }

    public byte[] CreateSpeedReplayMessage(int speed) {
        byte[] replyBuffer = new byte[6];
        int position = 0;
        byte[] header = CommonProtocolDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{25};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] speedBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, speed, speedBuf);
        System.arraycopy(speedBuf, 0, replyBuffer, position += command.length, speedBuf.length);
        byte[] serialByte = new byte[]{1};
        System.arraycopy(serialByte, 0, replyBuffer, position += speedBuf.length, serialByte.length);
        position += serialByte.length;
        return replyBuffer;
    }

    public byte[] CreateSlotReplayMessage(int mode) {
        byte[] replyBuffer = new byte[5];
        int position = 0;
        byte[] header = CommonProtocolDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{32};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] systemControl = new byte[]{(byte)mode};
        System.arraycopy(systemControl, 0, replyBuffer, position += command.length, systemControl.length);
        byte[] serialByte = new byte[]{1};
        System.arraycopy(serialByte, 0, replyBuffer, position += systemControl.length, serialByte.length);
        position += serialByte.length;
        return replyBuffer;
    }

    public byte[] CreateCarReplayMessage(int mode) {
        byte[] replyBuffer = new byte[5];
        int position = 0;
        byte[] header = CommonProtocolDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{33};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] systemControl = new byte[]{(byte)mode};
        System.arraycopy(systemControl, 0, replyBuffer, position += command.length, systemControl.length);
        byte[] serialByte = new byte[]{1};
        System.arraycopy(serialByte, 0, replyBuffer, position += systemControl.length, serialByte.length);
        position += serialByte.length;
        return replyBuffer;
    }

    public byte[] CreateLockMessage(int mode, int slotNumber) {
        byte[] replyBuffer = new byte[9];
        int position = 0;
        byte[] header = MonitorConstants.REPLY_HEADER_LOCK;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] slotBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotNumber, slotBuf);
        System.arraycopy(slotBuf, 0, replyBuffer, position += header.length, slotBuf.length);
        byte[] systemControl = new byte[]{(byte)mode};
        System.arraycopy(systemControl, 0, replyBuffer, position += slotBuf.length, systemControl.length);
        byte[] serialByte = new byte[]{-1, 13, 10};
        System.arraycopy(serialByte, 0, replyBuffer, position += systemControl.length, serialByte.length);
        position += serialByte.length;
        return replyBuffer;
    }

    public byte[] CreateCarModeMessage(int mode, int slotNumber) {
        byte[] replyBuffer = new byte[9];
        int position = 0;
        byte[] header = MonitorConstants.REPLY_HEADER_CAR_MODE;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] systemControl = new byte[]{(byte)mode};
        System.arraycopy(systemControl, 0, replyBuffer, position += header.length, systemControl.length);
        byte[] slotBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotNumber, slotBuf);
        System.arraycopy(slotBuf, 0, replyBuffer, position += systemControl.length, slotBuf.length);
        byte[] serialByte = new byte[]{-1, 13, 10};
        System.arraycopy(serialByte, 0, replyBuffer, position += slotBuf.length, serialByte.length);
        position += serialByte.length;
        return replyBuffer;
    }

    public void SendMessage(byte[] result) {
        Channel[] clients;
        if (result == null || result.length == 0) {
            return;
        }
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(client, result, false);
        }
    }

    private static class MonitorMessageHolder {
        private static final MonitorMessage INSTANCE = new MonitorMessage();

        private MonitorMessageHolder() {
        }
    }
}

