/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.monitor.decoders.items;

import com.simba.common.business.FrameUtils;
import com.simba.common.common.decoder.Decoder;
import com.simba.common.common.log.LogManager;
import com.simba.server.monitor.managers.MonitorManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class CarStatusDecoder
implements Decoder {
    private static final Logger logger = Logger.getLogger(CarStatusDecoder.class);
    public static final String NAME = "CarStatus";

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            byte[] content = (byte[])message;
            int carId = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            int carStatus = content[5];
            int carStatusNumber = MonitorManager.getInstance().getCarStatus(carId);
            if (carStatus == 3 || carStatusNumber == 3) {
                if (carStatus == 2) {
                    carStatus = 7;
                }
                MonitorManager.getInstance().updateCarStatus(carId, carStatus);
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Failed : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

