/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.framedecoder.decoders;

import com.simba.common.business.FrameUtils;
import com.simba.common.common.decoder.Decoder;
import com.simba.common.common.jsonserver.JsonChannelManager;
import com.simba.common.common.log.LogManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class EchoTimeDecoder
implements Decoder {
    public static final String NAME = "EchoTime";
    protected static final Logger logger = Logger.getLogger(EchoTimeDecoder.class);
    private static final int TIME_BUFFER_POSITION = 3;

    public static EchoTimeDecoder getInstance() {
        return EchoTimeDecoderHolder.INSTANCE;
    }

    private EchoTimeDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            long plcTime = FrameUtils.getInstance().getLongBigEndian(3, content);
            long now = System.currentTimeMillis();
            this.sendToRemoteLogger(plcTime, now);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "EchoTime Decode Catch Exception : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendToRemoteLogger(long plcTime, long now) {
        JSONObject echoTime = new JSONObject();
        String delta = String.valueOf(now - plcTime) + "ms";
        echoTime.put("ServiceName", NAME);
        echoTime.put("plcTime", plcTime);
        echoTime.put("serverTime", now);
        echoTime.put("delta", delta);
        String echoTimeStr = echoTime.toString();
        for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
            JsonChannelManager.getInstance().commitResponse(channel, echoTimeStr.getBytes(), false);
        }
    }

    private static class EchoTimeDecoderHolder {
        private static final EchoTimeDecoder INSTANCE = new EchoTimeDecoder();

        private EchoTimeDecoderHolder() {
        }
    }
}

