/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.dataclient;

import com.simba.common.common.frameclient.IClient;
import com.simba.common.common.log.LogManager;
import com.simba.common.dataclient.DataClientManager;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataClientNetTask
extends Thread {
    private static final Logger logger = Logger.getLogger(DataClientNetTask.class);
    private static final int RECONNECT_INTERVAL = 5000;

    public DataClientNetTask() {
        this.setName("Data-Client-Net-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Map<String, IClient> clients = DataClientManager.getInstance().getClientList();
                for (IClient clientData : clients.values()) {
                    if (clientData == null || clientData.isConnected().booleanValue()) continue;
                    LogManager.LogDebug(logger, "[DataClient.NetTask] Reconnect to common");
                    clientData.doReconnected();
                }
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogManager.LogError(logger, "[DataClient.NetTask] Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }
}

