/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.dataclient;

import com.simba.common.common.frameclient.ClientIoHandler;
import com.simba.common.common.frameclient.IBootstrapManager;
import com.simba.common.common.frameclient.connection.FrameClientPipelineFactory;
import com.simba.common.common.thread.CounterThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class BootstrapManager
implements IBootstrapManager {
    private ClientBootstrap bootstrap;
    private final ChannelUpstreamHandler clientIoHandler = new ClientIoHandler();
    public static final int EVENT_THREAD_POOL_SIZE = 2;
    public static final int IO_THREAD_POOL_SIZE = 2;
    private static final Logger logger = Logger.getLogger(BootstrapManager.class);

    public static BootstrapManager getInstance() {
        return BootstrapManagerHolder.INSTANCE;
    }

    private BootstrapManager() {
    }

    @Override
    public ClientBootstrap getClientBootstrap(String clientName) {
        return this.bootstrap;
    }

    @Override
    public void init() {
        this.initBootstrap();
    }

    private void initBootstrap() {
        ExecutorService bossExecutor = Executors.newCachedThreadPool();
        MemoryAwareThreadPoolExecutor workerExecutor = new MemoryAwareThreadPoolExecutor(2, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new CounterThreadFactory("Frame Client Worker Thread "));
        OrderedMemoryAwareThreadPoolExecutor eventExecutor = new OrderedMemoryAwareThreadPoolExecutor(2, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new CounterThreadFactory("Frame Client Event Thread "));
        this.bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory((Executor)bossExecutor, workerExecutor, 2));
        this.bootstrap.setPipelineFactory(new FrameClientPipelineFactory(eventExecutor, this.clientIoHandler));
        this.bootstrap.setOption("reuseAddress", true);
        this.bootstrap.setOption("child.reuseAddress", true);
        this.bootstrap.setOption("writeBufferHighWaterMark", 65536);
        this.bootstrap.setOption("writeBufferLowWaterMark", 32768);
        this.bootstrap.setOption("child.tcpNoDelay", true);
        this.bootstrap.setOption("child.keepAlive", true);
        this.bootstrap.setOption("child.sendBufferSize", 65536);
        this.bootstrap.setOption("child.receiveBufferSize", 65536);
    }

    private static class BootstrapManagerHolder {
        private static final BootstrapManager INSTANCE = new BootstrapManager();

        private BootstrapManagerHolder() {
        }
    }
}

