/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.simba.common.common.httpserver.HttpChannelManager;
import com.simba.common.common.utils.TemplateUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class HttpUtil {
    private Gson gson = new GsonBuilder().serializeNulls().create();
    private static HttpUtil instance = null;

    public static HttpUtil Instance() {
        if (instance == null) {
            instance = new HttpUtil();
        }
        return instance;
    }

    public void writeHttpResponse(Channel channel, Object template, HttpRequest request, Map<String, Object> maps) {
        this.writeResponse(channel, template, request, "text/html", maps);
    }

    public void writeJsonResponse(Channel channel, String content, HttpRequest request) {
        this.writeResponse(channel, content, request, "application/json", null);
    }

    public void writeJsonResponse(Channel channel, Map<String, Object> content, HttpRequest request) {
        this.writeResponse(channel, this.gson.toJson(content), request, "application/json", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(Channel channel, Object template, HttpRequest request, String type, Map<String, Object> maps) {
        String content;
        CookieDecoder cookieDecoder;
        Set<Cookie> cookies;
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setStatus(HttpResponseStatus.OK);
        String cookieString = request.getHeader("Cookie");
        if (cookieString != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", cookieEncoder.encode());
        }
        response.setHeader("Content-Encoding", "UTF-8");
        response.setHeader("Content-Type", type);
        if (template == null) {
            template = "";
        }
        if (template.toString().contains(".html")) {
            StringBuilder con = new StringBuilder();
            try {
                String temp;
                FileInputStream stream = new FileInputStream(template.toString());
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((temp = reader.readLine()) != null) {
                    con.append(temp);
                }
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                content = TemplateUtil.templateAnalysis(con.toString(), maps);
            }
        } else {
            content = template.toString();
        }
        ByteBuffer rawContent = ByteBuffer.wrap(content.getBytes());
        rawContent.rewind();
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer(rawContent);
        response.setHeader("Content-Length", rawContent.limit());
        response.setContent(channelBuffer);
        HttpChannelManager.getInstance().commitResponse(channel, response, false);
    }
}

