/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.processor;

import com.simba.common.CommonParam;
import com.simba.common.common.ChannelManager;
import com.simba.common.common.RequestHandler;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.processor.BaseProcessor;
import com.simba.common.common.utils.StringUtil;
import java.io.IOException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class FrameProcessor
extends BaseProcessor {
    private final ChannelManager channelManager;
    private final RequestHandler frameContentDecoder;

    public FrameProcessor(RequestHandler requestHandler, ChannelManager chManager) {
        this.frameContentDecoder = requestHandler;
        this.channelManager = chManager;
    }

    @Override
    public void onChannelConnected(Channel channel) throws Exception {
        this.addChannel(channel);
        this.logOnChannelConnected(channel);
        String content = "Welcome to connect to the common";
        this.channelManager.commitResponse(channel, content.getBytes(), false);
    }

    @Override
    public void onChannelDisconnected(Channel channel) throws Exception {
        this.removeChannel(channel);
        this.logOnChannelDisconnected(channel);
    }

    @Override
    public void onChannelIdle(Channel channel, IdleStateEvent e) throws Exception {
        this.logOnChannelIdel(channel, e);
    }

    @Override
    public void onExceptionCaught(Channel channel, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            this.logOnIOExceptionCaught(channel, cause);
        } else {
            this.logOnExceptionCaught(channel, cause);
            if (!channel.isConnected()) {
                this.removeChannel(channel);
            }
        }
    }

    @Override
    public void onMessageReceived(Channel channel, Object message) throws Exception {
        byte[] contentMsg = (byte[])message;
        this.logOnMessageReceived(channel, contentMsg);
        if (this.frameContentDecoder != null) {
            this.frameContentDecoder.handleRequest(channel, message);
        }
    }

    @Override
    public void onWriteComplete(Channel channel) throws Exception {
    }

    @Override
    protected void addChannel(Channel channel) {
        this.channelManager.addChannel(channel);
    }

    @Override
    protected void logOnChannelConnected(Channel channel) {
        LogManager.LogDebug(BaseProcessor.LOG, "[FrameProcessor.logOnChannelConnected] Connection opened [" + channel.getRemoteAddress() + "], Current frame content connection count is : " + String.valueOf(this.channelManager.getChannelCount()));
    }

    @Override
    protected void logOnMessageReceived(Channel channel, Object message) {
        try {
            if (CommonParam.LOG_MODE != 3) {
                byte[] content = (byte[])message;
                String contentStr = StringUtil.byteToHexString(content);
                LogManager.LogDebug(BaseProcessor.LOG, "[FrameProcessor.logOnMessageReceived] Received from [ip:" + channel.getRemoteAddress() + "] -- " + contentStr);
            }
        }
        catch (Exception e) {
            LogManager.LogError(BaseProcessor.LOG, "[FrameProcessor.logOnMessageReceived] Message received from [ip:" + channel.getRemoteAddress() + "] -- " + e.toString());
        }
        super.logOnMessageReceived(channel, message);
    }

    @Override
    protected void removeChannel(Channel channel) {
        String id = String.valueOf(channel.getId());
        this.channelManager.removeChannel(id);
    }
}

