/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.log;

import com.simba.common.common.log.Log4jLogger;
import com.simba.common.common.log.LogTask;
import com.simba.common.common.log.LoggerExecutor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LogHelper {
    private static Logger logger = Logger.getLogger(LogHelper.class);

    public static void configure(String accessLogPath, String errorLogPath) throws ParserConfigurationException, SAXException, IOException {
        accessLogPath = accessLogPath.replace('\\', '/');
        errorLogPath = errorLogPath.replace('\\', '/');
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringBuffer xmlBuffer = new StringBuffer();
        xmlBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlBuffer.append("<log4j:configuration xmlns:log4j=\"http://jakarta.apache.org/log4j/\">");
        xmlBuffer.append("<appender name=\"log4j.appender.FILE\" class=\"org.apache.log4j.DailyRollingFileAppender\">");
        xmlBuffer.append("<layout class=\"org.apache.log4j.PatternLayout\">");
        xmlBuffer.append("<param name=\"ConversionPattern\" value=\"%d{yyyy-MM-dd HH:mm:ss,SSS a z} %-5p - %m%n\"/>");
        xmlBuffer.append("</layout>");
        xmlBuffer.append("<param name=\"File\" value=\"" + accessLogPath + "\"/>");
        xmlBuffer.append("<param name=\"DatePattern\" value=\"'.'yyyy-MM-d\"/>");
        xmlBuffer.append("<filter class=\"org.apache.log4j.varia.LevelRangeFilter\">");
        xmlBuffer.append("<param name=\"LevelMin\" value=\"INFO\"/>");
        xmlBuffer.append("<param name=\"LevelMax\" value=\"INFO\"/>");
        xmlBuffer.append("</filter>");
        xmlBuffer.append("</appender>");
        xmlBuffer.append("<appender name=\"error\" class=\"org.apache.log4j.DailyRollingFileAppender\">");
        xmlBuffer.append("<layout class=\"org.apache.log4j.PatternLayout\">");
        xmlBuffer.append("<param name=\"ConversionPattern\" value=\"%d{yyyy-MM-dd HH:mm:ss,SSS a z} %-5p - %m%n\"/>");
        xmlBuffer.append("</layout>");
        xmlBuffer.append("<param name=\"File\" value=\"" + errorLogPath + "\"/>");
        xmlBuffer.append("<param name=\"DatePattern\" value=\"'.'yyyy-MM-d\"/>");
        xmlBuffer.append("<filter class=\"org.apache.log4j.varia.LevelRangeFilter\">");
        xmlBuffer.append("<param name=\"LevelMin\" value=\"WARN\"/>");
        xmlBuffer.append("<param name=\"LevelMax\" value=\"ERROR\"/>");
        xmlBuffer.append("</filter>");
        xmlBuffer.append("</appender>");
        xmlBuffer.append("<root>");
        xmlBuffer.append("<priority value=\"ALL\"/>");
        xmlBuffer.append("<appender-ref ref=\"log4j.appender.FILE\"/>");
        xmlBuffer.append("<appender-ref ref=\"error\"/>");
        xmlBuffer.append("</root>");
        xmlBuffer.append("</log4j:configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBuffer.toString().getBytes());
        Document doc = builder.parse(inputStream);
        Element e = doc.getDocumentElement();
        DOMConfigurator.configure(e);
    }

    public static void configureRootLog(int logMode, String verboseLogPath, String accessLogPath, String errorLogPath) throws Exception {
        verboseLogPath = verboseLogPath.replace('\\', '/');
        accessLogPath = accessLogPath.replace('\\', '/');
        errorLogPath = errorLogPath.replace('\\', '/');
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringBuffer xmlBuffer = new StringBuffer();
        xmlBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlBuffer.append("<log4j:configuration xmlns:log4j=\"http://jakarta.apache.org/log4j/\">");
        if (logMode == 0) {
            xmlBuffer.append("<appender name=\"stdout\" class=\"org.apache.log4j.ConsoleAppender\">");
            xmlBuffer.append("<layout class=\"org.apache.log4j.PatternLayout\">");
            xmlBuffer.append("<param name=\"ConversionPattern\" value=\"%d{yyyy-MM-dd HH:mm:ss,SSS a z} %-5p - %m%n\"/>");
            xmlBuffer.append("</layout>");
            xmlBuffer.append("<filter class=\"org.apache.log4j.varia.LevelRangeFilter\">");
            xmlBuffer.append("<param name=\"LevelMin\" value=\"DEBUG\"/>");
            xmlBuffer.append("<param name=\"LevelMax\" value=\"DEBUG\"/>");
            xmlBuffer.append("</filter>");
            xmlBuffer.append("</appender>");
        }
        if (logMode == 1) {
            xmlBuffer.append("<appender name=\"Verbose\" class=\"org.apache.log4j.DailyRollingFileAppender\">");
            xmlBuffer.append("<layout class=\"org.apache.log4j.PatternLayout\">");
            xmlBuffer.append("<param name=\"ConversionPattern\" value=\"%d{yyyy-MM-dd HH:mm:ss,SSS a z} %-5p - %m%n\"/>");
            xmlBuffer.append("</layout>");
            xmlBuffer.append("<param name=\"File\" value=\"" + verboseLogPath + "\"/>");
            xmlBuffer.append("<param name=\"DatePattern\" value=\"'.'yyyy-MM-d\"/>");
            xmlBuffer.append("</appender>");
        }
        xmlBuffer.append("<appender name=\"AInfo\" class=\"org.apache.log4j.DailyRollingFileAppender\">");
        xmlBuffer.append("<layout class=\"org.apache.log4j.PatternLayout\">");
        xmlBuffer.append("<param name=\"ConversionPattern\" value=\"%d{yyyy-MM-dd HH:mm:ss,SSS a z} %-5p - %m%n\"/>");
        xmlBuffer.append("</layout>");
        xmlBuffer.append("<param name=\"File\" value=\"" + accessLogPath + "\"/>");
        xmlBuffer.append("<param name=\"DatePattern\" value=\"'.'yyyy-MM-d\"/>");
        xmlBuffer.append("<filter class=\"org.apache.log4j.varia.LevelRangeFilter\">");
        xmlBuffer.append("<param name=\"LevelMin\" value=\"INFO\"/>");
        xmlBuffer.append("<param name=\"LevelMax\" value=\"INFO\"/>");
        xmlBuffer.append("</filter>");
        xmlBuffer.append("</appender>");
        xmlBuffer.append("<appender name=\"AError\" class=\"org.apache.log4j.DailyRollingFileAppender\">");
        xmlBuffer.append("<layout class=\"org.apache.log4j.PatternLayout\">");
        xmlBuffer.append("<param name=\"ConversionPattern\" value=\"%d{yyyy-MM-dd HH:mm:ss,SSS a z} %-5p - %m%n\"/>");
        xmlBuffer.append("</layout>");
        xmlBuffer.append("<param name=\"File\" value=\"" + errorLogPath + "\"/>");
        xmlBuffer.append("<param name=\"DatePattern\" value=\"'.'yyyy-MM-d\"/>");
        xmlBuffer.append("<filter class=\"org.apache.log4j.varia.LevelRangeFilter\">");
        xmlBuffer.append("<param name=\"LevelMin\" value=\"ERROR\"/>");
        xmlBuffer.append("<param name=\"LevelMax\" value=\"ERROR\"/>");
        xmlBuffer.append("</filter>");
        xmlBuffer.append("</appender>");
        xmlBuffer.append("<root>");
        xmlBuffer.append("<priority value=\"ALL\"/>");
        if (logMode == 0) {
            xmlBuffer.append("<appender-ref ref=\"stdout\"/>");
        }
        if (logMode == 1) {
            xmlBuffer.append("<appender-ref ref=\"Verbose\"/>");
        }
        xmlBuffer.append("<appender-ref ref=\"AInfo\"/>");
        xmlBuffer.append("<appender-ref ref=\"AError\"/>");
        xmlBuffer.append("</root>");
        xmlBuffer.append("</log4j:configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBuffer.toString().getBytes());
        Document doc = builder.parse(inputStream);
        Element e = doc.getDocumentElement();
        DOMConfigurator.configure(e);
    }

    public static void debug(Object message) {
        LogHelper.write(3, message);
    }

    public static void error(Object message) {
        LogHelper.write(2, message);
    }

    public static void fatal(Object message) {
        LogHelper.write(2, message);
    }

    public static void info(Object message) {
        LogHelper.write(1, message);
    }

    public static void trace(Object message) {
        LogHelper.write(3, message);
    }

    public static void warn(Object message) {
        LogHelper.write(0, message);
    }

    private static void write(int level, Object message) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), message, level));
    }
}

