/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.jsonserver;

import com.simba.common.common.RequestHandler;
import com.simba.common.common.jsonserver.jsonservice.DefaultJsonServiceContainer;
import com.simba.common.common.jsonserver.jsonservice.IJsonRequest;
import com.simba.common.common.jsonserver.jsonservice.JsonService;
import com.simba.common.common.jsonserver.jsonservice.JsonServiceContainer;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.thread.CommonExecutorFactory;
import com.simba.common.common.thread.CounterThreadFactory;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class JsonBaseManager
implements RequestHandler {
    public static final String JSON_SERVICE_NAME = "ServiceName";
    protected static final Logger logger = Logger.getLogger(JsonBaseManager.class);
    private static int ASYNC_HTTP_EXECUTOR_POOL_SIZE = 4;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Json-Service-Task";
    private final JsonServiceContainer container = new DefaultJsonServiceContainer();
    private Executor asyncJsonServiceExecutor;
    private BlockingQueue<Runnable> asyncJsonServiceOperationQueue;

    @Override
    public void handleRequest(final Channel channel, Object requestObj) {
        final byte[] request = (byte[])requestObj;
        this.runAsyncJsonTask(new Runnable(){

            @Override
            public void run() {
                block9: {
                    JsonService accessor = null;
                    JSONObject requestJSONObject = null;
                    try {
                        requestJSONObject = JsonBaseManager.this.parseServiceJsonData(request);
                        if (requestJSONObject == null) {
                            requestJSONObject = new JSONObject();
                            requestJSONObject.put("errorMessage", "\u8bf7\u6c42\u5185\u5bb9\u65e0\u6548");
                            accessor = JsonBaseManager.this.container.getJsonService("Error");
                            accessor.handleRequest(channel, requestJSONObject);
                            return;
                        }
                        String serviceName = requestJSONObject.getString(JsonBaseManager.JSON_SERVICE_NAME);
                        if (serviceName == null) {
                            requestJSONObject.put("errorMessage", "\u8bf7\u6c42\u8def\u7531\u4e3a\u7a7a");
                            accessor = JsonBaseManager.this.container.getJsonService("Error");
                            accessor.handleRequest(channel, requestJSONObject);
                            return;
                        }
                        if (serviceName.startsWith("/")) {
                            serviceName = serviceName.replaceAll("^(/+)|(/+)$", "");
                        }
                        String[] urls = serviceName.split("/");
                        accessor = JsonBaseManager.this.container.getJsonService(urls[0]);
                        if (accessor == null) {
                            requestJSONObject.put("errorMessage", "\u672a\u627e\u5230\u8bf7\u6c42\u8def\u7531\u5904\u7406\u5668");
                            accessor = JsonBaseManager.this.container.getJsonService("Error");
                            accessor.handleRequest(channel, requestJSONObject);
                            return;
                        }
                        Class<?> clz = accessor.getClass();
                        Method[] methods = clz.getDeclaredMethods();
                        if (methods == null || methods.length < 1) {
                            accessor.handleRequest(channel, requestJSONObject);
                            return;
                        }
                        for (Method method : methods) {
                            if (!method.isAnnotationPresent(IJsonRequest.class)) continue;
                            IJsonRequest re = method.getAnnotation(IJsonRequest.class);
                            String url = re.Url();
                            if (urls.length <= 1 || !urls[1].equals(url)) continue;
                            method.invoke((Object)accessor, channel, requestJSONObject);
                            return;
                        }
                        accessor.handleRequest(channel, requestJSONObject);
                    }
                    catch (Exception ex) {
                        if (requestJSONObject == null) {
                            requestJSONObject = new JSONObject();
                        }
                        requestJSONObject.put("errorMessage", "\u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage());
                        accessor = JsonBaseManager.this.container.getJsonService("Error");
                        accessor.handleRequest(channel, requestJSONObject);
                        LogManager.LogError(logger, "[JonServiceManager.handleRequest] Catch an exception  [" + channel.getRemoteAddress() + "] -- " + ex.getMessage());
                        if (!(ex instanceof InterruptedException)) break block9;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    public void init() {
        this.initJsonServiceContainer();
        this.initAsyncJsonTaskExcutor();
    }

    public abstract void initJsonServiceContainer();

    public void postInitProcess() {
        LogManager.LogDebug(logger, "[CommonJsonServiceManager.postInitProcess] Initialize successfully");
    }

    public void addJsonService(String serviceName, JsonService webService) {
        this.container.addJsonService(serviceName, webService);
    }

    private void initAsyncJsonTaskExcutor() {
        this.asyncJsonServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncJsonServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_HTTP_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncJsonServiceOperationQueue);
    }

    private JSONObject parseServiceJsonData(byte[] request) {
        JSONObject requestJSONObject = null;
        try {
            String jsonString = new String(request, "UTF-8");
            JSONTokener jsonTokener = new JSONTokener(jsonString);
            requestJSONObject = (JSONObject)jsonTokener.nextValue();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "[CommonJsonServiceManager.parseServiceJsonData] Parse Json services name exception -- " + ex.getMessage());
            requestJSONObject = null;
        }
        return requestJSONObject;
    }

    private void runAsyncJsonTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncJsonServiceExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogManager.LogError(logger, "[CommonJsonServiceManager.runAsyncJsonTask] Run async task to access json services request failed : " + e.getMessage());
        }
    }
}

