/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.httpserver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simba.common.common.RequestHandler;
import com.simba.common.common.httpserver.httpservice.DefaultHttpServiceContainer;
import com.simba.common.common.httpserver.httpservice.HttpService;
import com.simba.common.common.httpserver.httpservice.HttpServiceContainer;
import com.simba.common.common.httpserver.httpservice.IHttpRequest;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.thread.CommonExecutorFactory;
import com.simba.common.common.thread.CounterThreadFactory;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.Charsets;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public abstract class HttpBaseManager
implements RequestHandler {
    protected static final Logger logger = Logger.getLogger(HttpBaseManager.class);
    private static int ASYNC_HTTP_EXECUTOR_POOL_SIZE = 4;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Http-Service-Task";
    private final HttpServiceContainer container = new DefaultHttpServiceContainer();
    private Executor asyncWebServiceExecutor;
    private BlockingQueue<Runnable> asyncWebServiceOperationQueue;

    @Override
    public void handleRequest(final Channel channel, Object requestObj) {
        final HttpRequest request = (HttpRequest)requestObj;
        this.runAsyncHttpTask(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> clz;
                    Method[] methods;
                    Map<String, String> params;
                    ChannelBuffer contentBuffer = request.getContent();
                    HttpService accessor = null;
                    String contentStr = "No Content";
                    String methodName = request.getMethod().getName();
                    if (!methodName.equalsIgnoreCase("GET") && !contentBuffer.readable()) {
                        accessor = HttpBaseManager.this.container.getHttpService("ErrorRequestAccessor");
                        accessor.handleRequest(channel, "\u8bf7\u6c42\u5185\u5bb9\u65e0\u6548", request);
                        return;
                    }
                    if (!methodName.equalsIgnoreCase("GET")) {
                        contentStr = contentBuffer.toString(Charsets.UTF_8);
                        contentStr = URLDecoder.decode(contentStr, "UTF-8");
                        LogManager.LogDebug(logger, "The Request Content is : " + contentStr);
                    }
                    String[] urls = null;
                    try {
                        String name = request.getUri();
                        if (methodName.equals("GET")) {
                            String[] uriName = name.split("\\?");
                            if (uriName.length > 1) {
                                name = uriName[0];
                                contentStr = uriName[1];
                            } else if (uriName.length == 1) {
                                name = uriName[0];
                                contentStr = "";
                            } else {
                                name = "ErrorRequestAccessor";
                            }
                        }
                        if (name.startsWith("/")) {
                            name = name.replaceAll("^(/+)|(/+)$", "");
                        }
                        urls = name.split("/");
                        accessor = HttpBaseManager.this.container.getHttpService(urls[0]);
                        if (accessor == null) {
                            accessor = HttpBaseManager.this.container.getHttpService("ErrorRequestAccessor");
                            accessor.handleRequest(channel, "\u672a\u627e\u5230\u8bf7\u6c42\u8def\u7531", request);
                            return;
                        }
                    }
                    catch (Exception ex) {
                        accessor = HttpBaseManager.this.container.getHttpService("ErrorRequestAccessor");
                        accessor.handleRequest(channel, "\u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), request);
                        return;
                    }
                    try {
                        Gson gson = new GsonBuilder().serializeNulls().create();
                        params = (Map)gson.fromJson(contentStr, new TypeToken<Map<String, Object>>(){}.getType());
                    }
                    catch (Exception e) {
                        params = null;
                    }
                    if (params == null && contentStr.contains("=")) {
                        params = new HashMap();
                        String[] contents = contentStr.split("&");
                        for (int i = 0; i < contents.length; ++i) {
                            String[] param = contents[i].split("=");
                            params.put(param[0], param.length >= 2 ? param[1] : null);
                        }
                    }
                    if ((methods = (clz = accessor.getClass()).getDeclaredMethods()) == null || methods.length < 1) {
                        accessor.handleRequest(channel, params, request);
                        return;
                    }
                    for (Method method : methods) {
                        if (!method.isAnnotationPresent(IHttpRequest.class)) continue;
                        IHttpRequest re = method.getAnnotation(IHttpRequest.class);
                        String url = re.Url();
                        String requestMethod = re.Method();
                        if (!methodName.equals(requestMethod) || urls.length <= 1 || !urls[1].equals(url)) continue;
                        method.invoke((Object)accessor, channel, params, request);
                        return;
                    }
                    accessor.handleRequest(channel, params, request);
                }
                catch (Exception e) {
                    LogManager.LogError(logger, "Handle Http Request Content is : " + e.getMessage());
                    HttpService accessor = HttpBaseManager.this.container.getHttpService("ErrorRequestAccessor");
                    accessor.handleRequest(channel, "\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage(), request);
                }
            }
        });
    }

    public void init() {
        this.initHttpServiceContainer();
        this.initAsyncHttpTaskExcutor();
    }

    public void addHttpService(String serviceName, HttpService webService) {
        this.container.addHttpService(serviceName, webService);
    }

    public abstract void initHttpServiceContainer();

    public void postInitProcess() {
        LogManager.LogDebug(logger, "CommonHttpServiceManager initialize successfully");
    }

    private void initAsyncHttpTaskExcutor() {
        this.asyncWebServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncWebServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_HTTP_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncWebServiceOperationQueue);
    }

    private void runAsyncHttpTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncWebServiceExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogManager.LogError(logger, "run async task to access http request failed : " + e.getMessage());
        }
    }
}

