/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.frameserver;

import com.simba.common.CommonParam;
import com.simba.common.common.ChannelManager;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.utils.StringUtil;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class FrameChannelManager
implements ChannelManager {
    protected static final Logger logger = Logger.getLogger(FrameChannelManager.class);
    private final ConcurrentHashMap<String, Channel> channelList = new ConcurrentHashMap();
    private final List<String> headerFilters = new LinkedList<String>();

    public static FrameChannelManager getInstance() {
        return FrameChannelManagerHolder.INSTANCE;
    }

    private FrameChannelManager() {
    }

    @Override
    public void addChannel(Channel channel) {
        if (channel != null) {
            this.channelList.put(String.valueOf(channel.getId()), channel);
        }
    }

    public void addHeader(String header) {
        if (header == null || header.equals("")) {
            return;
        }
        if (this.headerFilters.contains(header)) {
            return;
        }
        this.headerFilters.add(header);
    }

    @Override
    public void clearChannelList() {
        this.channelList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture commitResponse(Channel channel, Object response, boolean close) {
        ChannelFuture writeFuture = null;
        byte[] msg = null;
        try {
            if (!(response instanceof byte[])) {
                ChannelFuture channelFuture = null;
                return channelFuture;
            }
            msg = (byte[])response;
            int limit = msg.length;
            ByteBuffer returnBuffer = ByteBuffer.allocate(limit);
            returnBuffer.put(msg, 0, limit);
            returnBuffer.rewind();
            ChannelBuffer duplicateBuffer = ChannelBuffers.wrappedBuffer(returnBuffer);
            writeFuture = channel.write(duplicateBuffer);
            if (this.isNeedClose(response, close)) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
        finally {
            if (CommonParam.LOG_MODE != 3) {
                try {
                    SocketAddress address = channel.getRemoteAddress();
                    this.recordFrameCommitBuffer(msg, address);
                }
                catch (Exception ex) {
                    LogManager.LogError(logger, "[FrameChannelManager.commitResponse] Message sent [" + channel.getRemoteAddress() + "] -- error: " + ex.toString());
                }
            }
        }
        return writeFuture;
    }

    @Override
    public boolean containsChannel(String key) {
        return this.channelList.containsKey(key);
    }

    @Override
    public Channel getChannel(String key) {
        return this.channelList.get(key.toLowerCase());
    }

    @Override
    public int getChannelCount() {
        return this.channelList.size();
    }

    @Override
    public Channel[] getChannelList() {
        return this.channelList.values().toArray(new Channel[0]);
    }

    @Override
    public boolean isNeedClose(Object response, boolean close) {
        return close;
    }

    @Override
    public Channel removeChannel(String key) {
        return this.channelList.remove(key);
    }

    private void recordFrameCommitBuffer(byte[] msg, SocketAddress address) {
        String content = StringUtil.byteToHexString(msg);
        Boolean checkHeader = false;
        for (String header : this.headerFilters) {
            if (!content.startsWith(header)) continue;
            checkHeader = true;
            break;
        }
        if (checkHeader.booleanValue()) {
            String logInfo = "[FrameChannelManager.commitResponse] Sent to [" + address + "] -- ";
            LogManager.LogDebug(logger, logInfo + content);
        }
    }

    private static class FrameChannelManagerHolder {
        private static final FrameChannelManager INSTANCE = new FrameChannelManager();

        private FrameChannelManagerHolder() {
        }
    }
}

