/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.frameclient.connection;

import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class TelNetClientPipelineFactory
implements ChannelPipelineFactory {
    protected static final int MAX_FRAME_LENGTH = 8192;
    protected final ExecutorService executor;
    protected final ChannelUpstreamHandler handler;

    public TelNetClientPipelineFactory(ExecutorService executor, ChannelUpstreamHandler handler) {
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("telnetDecoder", new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter()));
        pipeline.addLast("decoder", new StringDecoder());
        pipeline.addLast("encoder", new StringEncoder());
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        if (this.executor != null) {
            pipeline.addLast("executor", new ExecutionHandler(this.executor));
        }
        pipeline.addLast("handler", this.handler);
        return pipeline;
    }
}

