/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.frameclient.connection;

import com.simba.common.common.frameclient.command.Commands;
import com.simba.common.common.frameclient.connection.OperationCompleteHandler;
import com.simba.common.common.frameclient.connection.OperationFailureHandler;
import com.simba.common.common.log.LogManager;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class Channels {
    protected static final Logger logger = Logger.getLogger(Channels.class);

    public static void write(Channel channel, String content) {
        channel.write(content + '\u0000');
    }

    public static void writeInZlibFormat(Channel channel, String content, OperationCompleteHandler completeHandler, OperationFailureHandler failureHandler) {
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer(content.getBytes());
        Channels.doWriteMessage(channel, content, completeHandler, failureHandler, channelBuffer);
    }

    public static void writeWithDelimiter(Channel channel, String content, OperationCompleteHandler completeHandler, OperationFailureHandler failureHandler) {
        String delimiterMessage = content + '\u0000';
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer(delimiterMessage.getBytes());
        Channels.doWriteMessage(channel, content, completeHandler, failureHandler, channelBuffer);
    }

    protected static void doWriteMessage(final Channel channel, final String content, final OperationCompleteHandler completeHandler, final OperationFailureHandler failureHandler, ChannelBuffer channelBuffer) {
        ChannelFuture future = channel.write(channelBuffer);
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    Commands.execute(completeHandler);
                    LogManager.LogDebug(logger, "Message sent to [" + channel.getRemoteAddress().toString() + "] - " + content);
                } else {
                    Commands.execute(failureHandler);
                    LogManager.LogDebug(logger, "Failed to send message to [" + channel.getRemoteAddress().toString() + "] - " + content + " - " + future.getCause());
                }
            }
        });
    }
}

