/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.database.factory;

import com.simba.common.common.database.factory.interfaces.DbOperatorInterface;
import com.simba.common.common.database.factory.interfaces.DbPoolInterface;
import com.simba.common.common.log.LogManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DbOperator
implements DbOperatorInterface {
    private static final Logger logger = Logger.getLogger(DbOperator.class);
    protected Connection conn = null;
    protected PreparedStatement pstmt = null;

    public DbOperator(DbPoolInterface dbPool) {
        try {
            this.conn = dbPool.getConnection();
        }
        catch (Exception ex) {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    LogManager.LogError(logger, "DBOperator -- close connection from db pool error: " + ex);
                }
            }
            this.conn = null;
            LogManager.LogError(logger, "ADBOperator -- get connection from db pool error: " + ex);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void addBatch() throws Exception {
        this.pstmt.addBatch();
    }

    @Override
    public void addBatch(String sql) throws Exception {
        this.pstmt.addBatch(sql);
    }

    @Override
    public void clearParameters() throws Exception {
        if (null != this.pstmt) {
            this.pstmt.clearParameters();
        }
    }

    @Override
    public void close() {
        if (null != this.pstmt) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (Exception ex) {
                LogManager.LogError(logger, "AbstractDBOperator -- close prepared statement error: " + ex);
            }
        }
        if (null != this.conn) {
            try {
                this.conn.close();
            }
            catch (Exception ex) {
                LogManager.LogError(logger, "AbstractDBOperator -- close connection error: " + ex);
            }
        }
    }

    @Override
    public void closeJDBCResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "AbstractDBOperator -- close jdbc result set error: " + ex);
        }
    }

    @Override
    public boolean columnExists(String tableName, String columnName) throws Exception {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        return this.columnExistsCaseSensitive(dbMetaData, tableName, columnName) || this.columnExistsCaseSensitive(dbMetaData, tableName, columnName.toUpperCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName, columnName.toLowerCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US), columnName) || this.columnExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US), columnName.toUpperCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US), columnName.toLowerCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US), columnName) || this.columnExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US), columnName.toUpperCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US), columnName.toLowerCase(Locale.US));
    }

    @Override
    public void commit() throws SQLException {
        if (null != this.conn) {
            this.conn.commit();
        }
    }

    @Override
    public int[] executeBatch() throws Exception {
        return this.pstmt.executeBatch();
    }

    @Override
    public ResultSet executeQuery() throws Exception {
        return this.pstmt.executeQuery();
    }

    @Override
    public int executeUpdate() throws Exception {
        return this.pstmt.executeUpdate();
    }

    @Override
    public DatabaseMetaData getDatabaseMetaData() throws Exception {
        return this.conn.getMetaData();
    }

    @Override
    public boolean isAvaiableConnection() {
        boolean result = false;
        try {
            result = this.conn != null && !this.conn.isClosed();
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    public void prepareStatement(String sql) throws Exception {
        this.clearParameters();
        this.pstmt = this.conn.prepareStatement(sql);
    }

    @Override
    public void rollback() throws SQLException {
        if (null != this.conn) {
            this.conn.rollback();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (null != this.conn) {
            this.conn.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void setBoolean(int index, boolean value) throws Exception {
        this.pstmt.setBoolean(index, value);
    }

    @Override
    public void setDate(int index, Date value) throws Exception {
        this.pstmt.setString(index, value.toString());
    }

    @Override
    public void setDouble(int index, double value) throws Exception {
        this.pstmt.setDouble(index, value);
    }

    @Override
    public void setFetchSize(int rows) throws Exception {
        this.pstmt.setFetchSize(rows);
    }

    @Override
    public void setFloat(int index, float value) throws Exception {
        this.pstmt.setFloat(index, value);
    }

    @Override
    public void setInt(int index, int value) throws Exception {
        this.pstmt.setInt(index, value);
    }

    @Override
    public void setLong(int index, long value) throws Exception {
        this.pstmt.setLong(index, value);
    }

    @Override
    public void setNull(int index, int sqlType) throws Exception {
        this.pstmt.setNull(index, sqlType);
    }

    @Override
    public void setObject(int index, Object value) throws Exception {
        this.pstmt.setObject(index, value);
    }

    @Override
    public void setString(int index, String value) throws Exception {
        this.pstmt.setString(index, value);
    }

    @Override
    public void setTimestamp(int index, Timestamp value) throws Exception {
        this.pstmt.setTimestamp(index, value);
    }

    @Override
    public boolean tableExists(String tableName) throws Exception {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        return this.tableExistsCaseSensitive(dbMetaData, tableName) || this.tableExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US)) || this.tableExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean columnExistsCaseSensitive(DatabaseMetaData dbMetaData, String tableName, String columnName) throws Exception {
        ResultSet rsTables = dbMetaData.getColumns(null, null, tableName, columnName);
        try {
            boolean found;
            boolean bl = found = rsTables.next();
            return bl;
        }
        finally {
            this.closeJDBCResultSet(rsTables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExistsCaseSensitive(DatabaseMetaData dbMetaData, String tableName) throws Exception {
        ResultSet rsTables = dbMetaData.getTables(null, null, tableName, null);
        try {
            boolean found;
            boolean bl = found = rsTables.next();
            return bl;
        }
        finally {
            this.closeJDBCResultSet(rsTables);
        }
    }
}

