/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.database;

import com.simba.common.CommonParam;
import com.simba.common.common.database.factory.DatabaseParams;
import com.simba.common.common.database.helper.IDatabaseHelper;
import com.simba.common.common.database.type.DatabaseType;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.utils.XmlUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class DbManager {
    private static final Logger logger = Logger.getLogger(DbManager.class);
    public static final String PARAMETER_OCCUPY_PREFIX = "?";
    public static final String KEY_VAGUE_MORE = "*";
    public static final String KEY_VAGUE_ONE = "_";
    private final String configFileName;
    private IDatabaseHelper currentDbHelper;
    private Map<String, DatabaseParams> databases = new HashMap<String, DatabaseParams>();
    private static DbManager instance;

    public IDatabaseHelper GetDbHelper() {
        return this.currentDbHelper;
    }

    public static DbManager GetInstance() {
        if (instance == null) {
            instance = new DbManager();
        }
        return instance;
    }

    private DbManager() {
        this.configFileName = "etc" + CommonParam.PATH_SEP + "simba-mysql-config.xml";
    }

    public void Init() {
        try {
            this.ReadMysqlConfiguration(this.configFileName);
            this.ReadOracleConfiguration(this.configFileName);
            Iterator<DatabaseParams> iterator = this.databases.values().iterator();
            if (iterator.hasNext()) {
                DatabaseParams database = iterator.next();
                this.currentDbHelper = database.getHelper();
                return;
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "DbManager.Init Error -- Exception : " + ex);
        }
    }

    public IDatabaseHelper GetHelper(String key) {
        if (this.databases.containsKey(key)) {
            return this.databases.get(key).getHelper();
        }
        return null;
    }

    public void SetDefaultDbHelper(String key) {
        if (this.databases.containsKey(key)) {
            this.currentDbHelper = this.databases.get(key).getHelper();
        } else {
            Iterator<DatabaseParams> iterator = this.databases.values().iterator();
            if (iterator.hasNext()) {
                DatabaseParams database = iterator.next();
                this.currentDbHelper = database.getHelper();
                return;
            }
        }
    }

    public void ReadMysqlConfiguration(String configFilePath) {
        try {
            Document rootDoc = XmlUtil.getXmlDocFromFile(new File(configFilePath));
            Element root = rootDoc.getRootElement();
            List<Element> rootElements = root.getChildren("Mysql");
            for (Element rootElement : rootElements) {
                String key = rootElement.getChild("database-key").getText();
                DatabaseParams params = new DatabaseParams(key, DatabaseType.Mysql);
                params.setAliasPrefix(rootElement.getChild("alias-prefix").getText());
                params.setDatabaseAddress(rootElement.getChild("database-address").getText());
                params.setDatabaseHost(rootElement.getChild("database-host").getText());
                params.setDatabaseName(rootElement.getChild("database-name").getText());
                params.setDatabasePassword(rootElement.getChild("database-password").getText());
                params.setHouseKeepingTestSql(rootElement.getChild("database-house-keeping").getText());
                params.setDatabasePort(Integer.parseInt(rootElement.getChild("database-port").getText()));
                params.setDatabaseUser(rootElement.getChild("database-user").getText());
                params.setAlias(params.getAliasPrefix() + UUID.randomUUID().toString());
                params.setJdbcDriver("com.mysql.jdbc.Driver");
                params.setJdbcURL("jdbc:mysql://" + params.getDatabaseHost() + "/" + params.getDatabaseName() + "?autoReconnect=true&useUnicode=true&characterEncoding=utf-8&connectTimeout=5000&socketTimeout=5000&useOldAliasMetadataBehavior=true");
                params.Init();
                this.databases.put(key, params);
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Init MySQL Parameters Error -- Exception : " + ex);
        }
    }

    public void ReadOracleConfiguration(String configFilePath) {
        try {
            Document rootDoc = XmlUtil.getXmlDocFromFile(new File(configFilePath));
            Element root = rootDoc.getRootElement();
            List<Element> rootElements = root.getChildren("Oracle");
            for (Element rootElement : rootElements) {
                String key = rootElement.getChild("database-key").getText();
                DatabaseParams params = new DatabaseParams(key, DatabaseType.Oracle);
                String mode = rootElement.getAttribute("mode").getValue();
                String jdbcURL = "";
                params.setAliasPrefix(rootElement.getChild("alias-prefix").getText());
                params.setDatabaseUser(rootElement.getChild("database-user").getText());
                params.setDatabasePassword(rootElement.getChild("database-password").getText());
                params.setHouseKeepingTestSql(rootElement.getChild("database-house-keeping").getText());
                params.setAlias(params.getAliasPrefix() + UUID.randomUUID().toString());
                if (mode.equalsIgnoreCase("thin")) {
                    Element thinMessage = rootElement.getChild("thin");
                    String databaseHost = thinMessage.getChild("database-host").getText();
                    params.setDatabaseHost(databaseHost);
                    String databasePort = thinMessage.getChild("database-port").getText();
                    params.setDatabasePort(Integer.parseInt(databasePort));
                    String databaseSid = thinMessage.getChild("database-sid").getText();
                    params.setDatabaseSid(databaseSid);
                    jdbcURL = "jdbc:oracle:thin:@" + databaseHost + ":" + databasePort + ":" + databaseSid;
                } else if (mode.equalsIgnoreCase("oci")) {
                    Element ociElement = rootElement.getChild("oci");
                    String serviceName = ociElement.getChild("services-name").getText();
                    jdbcURL = "jdbc:oracle:oci8:@" + serviceName;
                }
                params.setJdbcURL(jdbcURL);
                params.setJdbcDriver("oracle.jdbc.driver.OracleDriver");
                params.Init();
                this.databases.put(key, params);
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Init Oracle Parameters Error -- Exception : " + ex);
        }
    }

    public void ShutDown() {
        for (DatabaseParams database : this.databases.values()) {
            database.ShutDown();
        }
    }
}

