/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class BaseService {
    public Gson gson = new GsonBuilder().serializeNulls().create();

    protected <T> Map<String, T> getMapByParam(Map<String, Object> content, String key, Type type) {
        Object obj = content.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (Map)this.gson.fromJson(obj.toString(), type);
        }
        if (obj instanceof Map) {
            return (Map)this.gson.fromJson(this.gson.toJson(obj), type);
        }
        throw new ClassCastException();
    }

    protected String getStringByParam(Map<String, Object> content, String key) {
        Object obj = content.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj instanceof Double) {
            int value = ((Double)obj).intValue();
            if ((double)value == (Double)obj) {
                return ((Double)obj).intValue() + "";
            }
            return obj.toString();
        }
        throw new ClassCastException();
    }

    protected <T> List<T> getListByParam(Map<String, Object> content, String key, Type type) {
        Object obj = content.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (List)this.gson.fromJson(obj.toString(), type);
        }
        if (obj instanceof List) {
            return (List)this.gson.fromJson(this.gson.toJson(obj), type);
        }
        throw new ClassCastException();
    }

    protected int getIntegerByParam(Map<String, Object> content, String key, int defaultValue) {
        Object obj = content.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            return Integer.parseInt(obj.toString());
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        throw new ClassCastException();
    }

    protected boolean getBooleanByParam(Map<String, Object> content, String key, boolean defaultValue) {
        Object obj = content.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean(obj.toString());
        }
        throw new ClassCastException();
    }

    protected <T> T[] getArrayByParam(Map<String, Object> content, String key, Type type) {
        Object obj = content.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (Object[])this.gson.fromJson(obj.toString(), type);
        }
        if (obj instanceof List) {
            return (Object[])this.gson.fromJson(this.gson.toJson(obj), type);
        }
        if (obj.getClass().isArray()) {
            return (Object[])this.gson.fromJson(this.gson.toJson(obj), type);
        }
        throw new ClassCastException();
    }
}

