/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.business;

import org.apache.log4j.Logger;

public class FrameUtils {
    protected static final Logger logger = Logger.getLogger(FrameUtils.class);

    public static FrameUtils getInstance() {
        return FrameUtilsHolder.INSTANCE;
    }

    private FrameUtils() {
    }

    public byte[] createSystemTimeToBuffer() {
        byte[] timeBuffer = new byte[8];
        long now = System.currentTimeMillis();
        FrameUtils.getInstance().setLongBigEndian(0, now, timeBuffer);
        return timeBuffer;
    }

    public long getLongBigEndian(int index, byte[] array) {
        return ((long)array[index] & 0xFFL) << 56 | ((long)array[index + 1] & 0xFFL) << 48 | ((long)array[index + 2] & 0xFFL) << 40 | ((long)array[index + 3] & 0xFFL) << 32 | ((long)array[index + 4] & 0xFFL) << 24 | ((long)array[index + 5] & 0xFFL) << 16 | ((long)array[index + 6] & 0xFFL) << 8 | (long)array[index + 7] & 0xFFL;
    }

    public long getUnsignedIntBigEndian(int index, byte[] array) {
        return (long)this.getIntBigEndian(index, array) & 0xFFFFFFFFL;
    }

    public int getUnsignedShortBigEndian(int index, byte[] array) {
        return this.getShortBigEndian(index, array) & 0xFFFF;
    }

    public int getUnsignedShortLittleEndian(int index, byte[] array) {
        return this.getShortLittleEndian(index, array) & 0xFFFF;
    }

    public void setIntBigEndian(int index, int value, byte[] array) {
        array[index] = (byte)(value >>> 24);
        array[index + 1] = (byte)(value >>> 16);
        array[index + 2] = (byte)(value >>> 8);
        array[index + 3] = (byte)value;
    }

    public void setLongBigEndian(int index, long value, byte[] array) {
        array[index] = (byte)(value >>> 56);
        array[index + 1] = (byte)(value >>> 48);
        array[index + 2] = (byte)(value >>> 40);
        array[index + 3] = (byte)(value >>> 32);
        array[index + 4] = (byte)(value >>> 24);
        array[index + 5] = (byte)(value >>> 16);
        array[index + 6] = (byte)(value >>> 8);
        array[index + 7] = (byte)value;
    }

    public void setShortBigEndian(int index, int value, byte[] array) {
        array[index] = (byte)(value >>> 8);
        array[index + 1] = (byte)value;
    }

    public void setShortLittleEndian(int index, int value, byte[] array) {
        array[index] = (byte)value;
        array[index + 1] = (byte)(value >>> 8);
    }

    private int getIntBigEndian(int index, byte[] array) {
        return (array[index] & 0xFF) << 24 | (array[index + 1] & 0xFF) << 16 | (array[index + 2] & 0xFF) << 8 | array[index + 3] & 0xFF;
    }

    private short getShortBigEndian(int index, byte[] array) {
        return (short)(array[index] << 8 | array[index + 1] & 0xFF);
    }

    private short getShortLittleEndian(int index, byte[] array) {
        return (short)(array[index] & 0xFF | array[index + 1] << 8);
    }

    private static class FrameUtilsHolder {
        private static final FrameUtils INSTANCE = new FrameUtils();

        private FrameUtilsHolder() {
        }
    }
}

