/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.logicalcobwebs.proxool.admin.StatisticsIF;
import org.logicalcobwebs.proxool.admin.StatisticsListenerIF;

public class StatisticsLogger
implements StatisticsListenerIF {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private Log log;
    private String logLevel;

    public StatisticsLogger(Log log, String logLevel) {
        this.log = log;
        this.logLevel = logLevel;
    }

    public void statistics(String alias, StatisticsIF statistics) {
        if (statistics != null && this.logLevel != null) {
            StringBuffer out = new StringBuffer();
            out.append(TIME_FORMAT.format(statistics.getStartDate()));
            out.append(" - ");
            out.append(TIME_FORMAT.format(statistics.getStopDate()));
            out.append(", s:");
            out.append(statistics.getServedCount());
            out.append(":");
            out.append(DECIMAL_FORMAT.format(statistics.getServedPerSecond()));
            out.append("/s, r:");
            out.append(statistics.getRefusedCount());
            out.append(":");
            out.append(DECIMAL_FORMAT.format(statistics.getRefusedPerSecond()));
            out.append("/s, a:");
            out.append(DECIMAL_FORMAT.format(statistics.getAverageActiveTime()));
            out.append("ms/");
            out.append(DECIMAL_FORMAT.format(statistics.getAverageActiveCount()));
            if (this.logLevel.equals("TRACE")) {
                this.log.trace(out.toString());
            } else if (this.logLevel.equals("DEBUG")) {
                this.log.debug(out.toString());
            } else if (this.logLevel.equals("INFO")) {
                this.log.info(out.toString());
            }
        }
    }
}

