/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.StringUtil;
import com.simba.server.components.BarcodeManager;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatManager;
import com.simba.server.components.data.SortInfo;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class ScanInfoJsonService
implements JsonService {
    public static final String NAME = "PlatScanned";
    private static final Logger logger = Logger.getLogger(ScanInfoJsonService.class);

    @Override
    public void handleRequest(Channel connection, Object jsonData) {
        try {
            JSONObject request = (JSONObject)jsonData;
            String type = request.getString("Barcode");
            if (StringUtil.isNull(type).booleanValue()) {
                return;
            }
            LogUtil.LogDebug(logger, "[PlatScanned] Recv Scanned Msg :" + request.toString());
            this.handleManualScanned(connection, request);
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "[PlatScanned] Scanned Json Request Service Error : exception info : " + ex.getMessage());
        }
    }

    private void handleManualScanned(Channel channel, JSONObject request) {
        String platId = request.getString("PlatId");
        String barcode = request.getString("Barcode");
        JSONObject scannedObj = new JSONObject();
        scannedObj.put("platId", platId);
        scannedObj.put("platMode", "3");
        scannedObj.put("barcode", barcode);
        scannedObj.put("plcId", NAME);
        scannedObj.put("scannedMode", "PLC");
        scannedObj.put("scannedPlatType", "AUTO");
        PlatInstance plat = PlatManager.getInstance().getPlatById(platId);
        if (plat == null) {
            this.sendErrorResponse(channel, platId);
            return;
        }
        if (!BarcodeManager.getInstance().checkBarcodeValid(barcode)) {
            String Message2 = "\u6761\u7801\u4e0d\u7b26\u5408\u6821\u9a8c\u89c4\u5219!";
            this.sendErrorResponse(channel, Message2);
            return;
        }
        SortInfo sortInfo = plat.handleScannedCommand(channel, scannedObj);
        this.sendSuccessResponse(channel, sortInfo);
    }

    private void sendErrorResponse(Channel channel, String Message2) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", NAME);
        response.put("Barcode", "");
        response.put("SlotId", "");
        response.put("Message", Message2);
        JSONObject jsonObject = new JSONObject(response);
        JsonChannelManager.getInstance().commitResponse(channel, jsonObject.toString().getBytes(), false);
    }

    private void sendSuccessResponse(Channel channel, SortInfo sortInfo) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", NAME);
        response.put("Barcode", sortInfo.getBarcode());
        response.put("SlotId", sortInfo.getSlotsList().toString());
        response.put("Message", "success");
        JSONObject jsonObject = new JSONObject(response);
        LogUtil.LogDebug(logger, "[ScanInfoJsonService]" + response);
        JsonChannelManager.getInstance().commitResponse(channel, jsonObject.toString().getBytes(), false);
    }
}

