/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.StringUtil;
import com.simba.server.components.MachineParams;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class ChangeSortModeJsonService
implements JsonService {
    public static final String NAME = "ChangeSortMode";
    private static final Logger logger = Logger.getLogger(ChangeSortModeJsonService.class);

    @Override
    public void handleRequest(Channel connection, Object jsonData) {
        try {
            JSONObject request = (JSONObject)jsonData;
            String SortMode2 = request.getString("SortMode");
            if (StringUtil.isNull(SortMode2).booleanValue()) {
                String Message2 = "\u53c2\u6570\u4e0d\u5408\u6cd5!";
                this.sendErrorResponse(connection, Message2);
                return;
            }
            LogUtil.LogDebug(logger, "[ChangeSortModeJsonService] Recv ChangeSortMode Msg :" + request.toString());
            this.handleManualScanned(connection, request);
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "[ChangeSortModeJsonService] Json Request Service Error : exception info : " + ex.getMessage());
        }
    }

    private void handleManualScanned(Channel channel, JSONObject request) {
        String SortMode2 = request.getString("SortMode");
        if (SortMode2.equals("sorting")) {
            MachineParams.getInstance().setSortingSortMode();
            this.sendSuccessResponse(channel, SortMode2);
        } else if (SortMode2.equals("transferring")) {
            MachineParams.getInstance().setTransferringSortMode();
            this.sendSuccessResponse(channel, SortMode2);
        } else {
            String Message2 = "\u53c2\u6570\u4e0d\u5408\u6cd5!";
            this.sendErrorResponse(channel, Message2);
        }
    }

    private void sendErrorResponse(Channel channel, String Message2) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", NAME);
        response.put("Message", Message2);
        JSONObject jsonObject = new JSONObject(response);
        JsonChannelManager.getInstance().commitResponse(channel, jsonObject.toString().getBytes(), false);
    }

    private void sendSuccessResponse(Channel channel, String SortMode2) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", NAME);
        response.put("Message", "success");
        response.put("SortMode", SortMode2);
        JSONObject jsonObject = new JSONObject(response);
        LogUtil.LogDebug(logger, "[ChangeSortModeJsonService]" + response);
        JsonChannelManager.getInstance().commitResponse(channel, jsonObject.toString().getBytes(), false);
    }
}

