/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice;

import com.simba.common.RequestHandler;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.DefaultJsonServiceContainer;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.jsonservice.JsonServiceContainer;
import com.simba.common.log.LogUtil;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.jsonservice.serivces.ChangeSortModeJsonService;
import com.simba.server.jsonservice.serivces.EchoJsonService;
import com.simba.server.jsonservice.serivces.ErrorJsonService;
import com.simba.server.jsonservice.serivces.RenewTrashSlotJsonService;
import com.simba.server.jsonservice.serivces.ResetPlatJsonService;
import com.simba.server.jsonservice.serivces.ScanInfoJsonService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonServiceManager
implements RequestHandler {
    public static final String JSON_SERVICE_NAME = "ServiceName";
    protected static final Logger logger = Logger.getLogger(JsonServiceManager.class);
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Json-Service-Task";
    private static int EXECUTOR_POOL_SIZE = 3;
    private Executor asyncJsonServiceExecutor;
    private BlockingQueue<Runnable> asyncJsonServiceOperationQueue;
    private final JsonServiceContainer container = new DefaultJsonServiceContainer();

    public static JsonServiceManager getInstance() {
        return JsonServiceManagerHolder.INSTANCE;
    }

    private JsonServiceManager() {
    }

    @Override
    public void handleRequest(final Channel channel, Object requestObj) {
        final byte[] request = (byte[])requestObj;
        Runnable serviceTask = new Runnable(){

            @Override
            public void run() {
                block6: {
                    JsonService accessor = null;
                    try {
                        JSONObject requestJSONObject = JsonServiceManager.this.parseServiceJsonData(request);
                        if (requestJSONObject == null) {
                            return;
                        }
                        String serviceName = requestJSONObject.getString(JsonServiceManager.JSON_SERVICE_NAME);
                        if (serviceName == null) {
                            return;
                        }
                        accessor = JsonServiceManager.this.container.getJsonService(serviceName);
                        if (accessor == null) {
                            accessor = JsonServiceManager.this.container.getJsonService("Error");
                        }
                        if (accessor != null) {
                            accessor.handleRequest(channel, requestJSONObject);
                        }
                    }
                    catch (Exception ex) {
                        LogUtil.LogError(logger, "When Json server handlerRequest exception  [" + channel.getRemoteAddress() + "] -- " + ex.getMessage());
                        if (!(ex instanceof InterruptedException)) break block6;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.executeInThreadPool(serviceTask);
    }

    public void init() {
        this.initJsonServiceContainer();
        this.initAsyncJsonTaskExcutor();
    }

    public void postInitProcess() {
        LogUtil.LogDebug(logger, "JsonServiceManager initialize successfully");
    }

    public void sendEchoDataToRemoteLogger() {
        Channel[] clientChannels;
        for (Channel channel : clientChannels = JsonChannelManager.getInstance().getChannelList()) {
            String sortInfoContent = "{\"ServiceName\":\"Echo\",\"Channel-Id\":\"" + channel.getId() + "\"}";
            JsonChannelManager.getInstance().commitResponse(channel, sortInfoContent.getBytes(), false);
        }
    }

    private void executeInThreadPool(Runnable executeRunnable) {
        this.runAsyncJsonTask(executeRunnable);
    }

    private void initAsyncJsonTaskExcutor() {
        this.asyncJsonServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncJsonServiceExecutor = CommonExecutorFactory.newFixedThreadPool(EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncJsonServiceOperationQueue);
    }

    private void initJsonServiceContainer() {
        this.container.addJsonService("Echo", new EchoJsonService());
        this.container.addJsonService("Error", new ErrorJsonService());
        this.container.addJsonService("ResetPlat", new ResetPlatJsonService());
        this.container.addJsonService("RenewTrashSlot", new RenewTrashSlotJsonService());
        this.container.addJsonService("PlatScanned", new ScanInfoJsonService());
        this.container.addJsonService("ChangeSortMode", new ChangeSortModeJsonService());
    }

    private JSONObject parseServiceJsonData(byte[] request) {
        JSONObject requestJSONObject = null;
        try {
            String jsonString = new String(request, "UTF-8");
            JSONTokener jsonTokener = new JSONTokener(jsonString);
            requestJSONObject = (JSONObject)jsonTokener.nextValue();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Parse Json service name exception -- " + ex.getMessage());
            requestJSONObject = null;
        }
        return requestJSONObject;
    }

    private void runAsyncJsonTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncJsonServiceExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "run async task to access json service request failed : " + e.getMessage());
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    private static class JsonServiceManagerHolder {
        private static final JsonServiceManager INSTANCE = new JsonServiceManager();

        private JsonServiceManagerHolder() {
        }
    }
}

