/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.httpservice.serivces;

import com.simba.common.httpserver.HttpChannelManager;
import com.simba.common.httpserver.httpservice.HttpService;
import com.simba.common.log.LogUtil;
import com.simba.server.components.MachineParams;
import com.simba.server.components.SortProtocolCreator;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class SortMode
implements HttpService {
    public static final String NAME = "sort_mode";
    private static final Logger logger = Logger.getLogger(SortMode.class);

    @Override
    public void handleRequest(Channel channel, Object content, HttpRequest request) {
        try {
            JSONObject requestObj = new JSONObject(content.toString());
            LogUtil.LogDebug(logger, "[SortMode] sort_mode: " + requestObj);
            String pipeline = requestObj.getString("pipeline");
            JSONObject jsonObj = this.createRequest();
            this.SubmitResponseContent(channel, request, jsonObj);
        }
        catch (JSONException ex) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("status", "fail");
            jsonObj.put("statusCode", "400");
            jsonObj.put("statusInfo", "\u53c2\u6570\u4e0d\u5408\u6cd5!");
            jsonObj.put("remark", "\u65e0");
            this.SubmitResponseContent(channel, request, jsonObj);
            LogUtil.LogError(logger, "[SortMode] Catch Exception : :" + ex.toString());
        }
    }

    private void SubmitResponseContent(Channel channel, HttpRequest request, JSONObject jsonObj) {
        HttpResponse response = SortProtocolCreator.getInstance().createHttpResponse(request, jsonObj.toString());
        HttpChannelManager.getInstance().commitResponse(channel, response, true);
    }

    private JSONObject createRequest() {
        JSONObject requestObj = new JSONObject();
        requestObj.put("status", "success");
        requestObj.put("statusCode", "OK");
        requestObj.put("statusInfo", "OK");
        requestObj.put("remark", MachineParams.getInstance().getSortMode());
        return requestObj;
    }
}

