/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.httpservice.serivces;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.httpserver.HttpChannelManager;
import com.simba.common.httpserver.httpservice.HttpService;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.CrossSorterInfo;
import com.simba.server.components.data.SortInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ComplementInfo
implements HttpService {
    public static final String NAME = "complement_info";
    private static final Logger logger = Logger.getLogger(ComplementInfo.class);

    @Override
    public void handleRequest(Channel channel, Object content, HttpRequest request) {
        try {
            JSONObject requestObj = new JSONObject(content.toString());
            LogUtil.LogDebug(logger, "[ComplementInfo] complementInfo: " + requestObj);
            String sortingId = requestObj.getString("sortingId");
            String trayCode = requestObj.getString("trayCode");
            String billCode = requestObj.getString("billCode");
            String pipeline = requestObj.getString("pipeline");
            String sortSource = requestObj.getString("sortSource");
            String sortCode = requestObj.getString("sortCode");
            SortInfo sortInfo = SortInfoManager.getInstance().getSortInfo(trayCode);
            if (sortInfo == null) {
                return;
            }
            this.getChuteCodes(requestObj, sortInfo);
            SortInfoManager.getInstance().handleSortInfoResult(sortInfo);
            byte[] sortResultBuffer = SortProtocolCreator.getInstance().createSortCmdWithCarID(sortInfo);
            this.sendToPlcChannel(sortResultBuffer, pipeline);
            JSONObject jsonObj = this.createRequest();
            this.SubmitResponseContent(channel, request, jsonObj);
        }
        catch (JSONException ex) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("status", "fail");
            jsonObj.put("statusCode", "400");
            jsonObj.put("statusInfo", "\u53c2\u6570\u4e0d\u5408\u6cd5!");
            jsonObj.put("remark", "\u65e0");
            this.SubmitResponseContent(channel, request, jsonObj);
            LogUtil.LogError(logger, "[updateCacheNotice] Catch Exception : :" + ex.toString());
        }
    }

    private void SubmitResponseContent(Channel channel, HttpRequest request, JSONObject jsonObj) {
        HttpResponse response = SortProtocolCreator.getInstance().createHttpResponse(request, jsonObj.toString());
        HttpChannelManager.getInstance().commitResponse(channel, response, true);
    }

    private JSONObject createRequest() {
        JSONObject requestObj = new JSONObject();
        requestObj.put("status", "success");
        requestObj.put("statusCode", "OK");
        requestObj.put("statusInfo", "OK");
        requestObj.put("remark", "OK");
        return requestObj;
    }

    private void getChuteCodes(JSONObject responseObj, SortInfo sortInfo) {
        JSONArray chuteCodeArray = responseObj.getJSONArray("sortPortCode");
        int chuteCodeLength = chuteCodeArray.length();
        if (chuteCodeLength > 0) {
            sortInfo.getSlotsList().clear();
            sortInfo.getChuteCodeList().clear();
        } else {
            sortInfo.setErrorCodeSVR(1);
        }
        for (int i = 0; i < chuteCodeLength; ++i) {
            String slotId = chuteCodeArray.getString(i);
            slotId = slotId.substring(slotId.length() - 3);
            sortInfo.getSlotsList().add(Integer.parseInt(slotId));
            sortInfo.getChuteCodeList().add(slotId);
        }
    }

    private void sendToPlcChannel(byte[] sortResultBuffer, String pipeline) {
        try {
            CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByPipeline(pipeline);
            if (crossSorterInfo == null) {
                LogUtil.LogDebug(logger, "[ComplementInfo]: Pipeline not found!  --" + pipeline);
                return;
            }
            Channel tmpChannel = crossSorterInfo.getSorterChannel();
            FrameChannelManager.getInstance().commitResponse(tmpChannel, sortResultBuffer, false);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ComplementInfo]:[sendToPlcChannel] ,[Message]:[Send sort result to plc channels error : " + ex.getMessage() + "]");
        }
    }
}

