/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.httpservice;

import com.simba.common.RequestHandler;
import com.simba.common.httpserver.httpservice.DefaultHttpServiceContainer;
import com.simba.common.httpserver.httpservice.HttpService;
import com.simba.common.log.LogUtil;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.httpservice.serivces.ComplementInfo;
import com.simba.server.httpservice.serivces.ErrorHttpService;
import com.simba.server.httpservice.serivces.SortMode;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class HttpServiceManager
implements RequestHandler {
    public static final String WEBSOCKET_SERVICE_NAME = "ServiceName";
    protected static final Logger logger = Logger.getLogger(HttpServiceManager.class);
    private static int ASYNC_HTTP_EXECUTOR_POOL_SIZE = 4;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Http-Service-Task";
    private Executor asyncHttpServiceExecutor;
    private BlockingQueue<Runnable> asyncHttpServiceOperationQueue;
    private final DefaultHttpServiceContainer container = new DefaultHttpServiceContainer();

    public static HttpServiceManager getInstance() {
        return HttpServiceManagerHolder.INSTANCE;
    }

    private HttpServiceManager() {
    }

    @Override
    public void handleRequest(final Channel channel, final Object requestObj) {
        this.runAsyncWebSocketTask(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        HttpService accessor = null;
                        String request = null;
                        HttpRequest httpRequest = null;
                        try {
                            String jsonString;
                            httpRequest = (HttpRequest)requestObj;
                            String uri = httpRequest.getUri();
                            String serviceName = uri.substring(uri.lastIndexOf("/") + 1);
                            if (serviceName == null) {
                                return;
                            }
                            accessor = HttpServiceManager.this.container.getHttpService(serviceName);
                            if (accessor == null) {
                                LogUtil.LogDebug(logger, "[HttpServiceManager] uri not found :" + uri);
                                return;
                            }
                            request = jsonString = new String(httpRequest.getContent().array(), "UTF-8");
                        }
                        catch (Exception ex) {
                            accessor = HttpServiceManager.this.container.getHttpService("ErrorHttpService");
                        }
                        if (accessor != null) {
                            accessor.handleRequest(channel, request, httpRequest);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.LogDebug(logger, "Handle WebSocket Request Content is : " + e.getMessage());
                        if (!(e instanceof InterruptedException)) break block7;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    public void init() {
        this.initHttpServiceContainer();
        this.initAsyncHttpTaskExcutor();
    }

    public void postInitProcess() {
        LogUtil.LogDebug(logger, "[HttpServiceManager.postInitProcess] initialize successfully!");
    }

    private void initAsyncHttpTaskExcutor() {
        this.asyncHttpServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncHttpServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_HTTP_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncHttpServiceOperationQueue);
    }

    private void initHttpServiceContainer() {
        this.container.addHttpService("ErrorHttpService", new ErrorHttpService());
        this.container.addHttpService("complement_info", new ComplementInfo());
        this.container.addHttpService("sort_mode", new SortMode());
    }

    private void runAsyncWebSocketTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncHttpServiceExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "[HttpServiceManager] run async task to access WebSocket request failed : " + e.getMessage());
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    private static class HttpServiceManagerHolder {
        private static final HttpServiceManager INSTANCE = new HttpServiceManager();

        private HttpServiceManagerHolder() {
        }
    }
}

