/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.BarcodeManager;
import com.simba.server.components.PlatManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.CrossSorterInfo;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SortInfo;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SortInfoDecoder
implements Decoder {
    public static final int CAR_HAS_NO_PACKET = 0;
    public static final int CAR_HAS_PACKET = 1;
    public static final String NAME = "SortInfo";
    protected static final Logger logger = Logger.getLogger(SortInfoDecoder.class);
    private static final int BARCODE_NUMBER_POSITION = 8;
    private static final int CAR_ID_POSITION = 3;
    private static final int CAR_STATUS_POSITION = 5;
    private static final String INVALID_READ_BARCODE = "Invalid-Code";
    private static final int OBR_NUM_POSITION = 7;
    private static final int TRIGGER_STATUS_POSITION = 6;
    private static final int TRIGGER_TO_GET_SLOT = 1;

    public static SortInfoDecoder getInstance() {
        return DecoderHolder.INSTANCE;
    }

    private SortInfoDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            if (!(message instanceof byte[])) {
                return;
            }
            byte[] content = (byte[])message;
            InetSocketAddress socketAddress = (InetSocketAddress)connection.getRemoteAddress();
            String clientIP = socketAddress.getAddress().getHostAddress();
            CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByIP(clientIP);
            if (crossSorterInfo == null) {
                LogUtil.LogDebug(logger, "[SortInfoDecoder]: IP not found!  --" + clientIP);
                return;
            }
            crossSorterInfo.setSorterChannel(connection);
            int carIdInt = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String carId = String.valueOf(carIdInt);
            byte carStatus = content[5];
            if (carStatus != 1) {
                return;
            }
            byte triggerStatus = content[6];
            if (triggerStatus != 1) {
                return;
            }
            String trayCode = SortProtocolCreator.getInstance().createTrayCode(crossSorterInfo.getSorterPipeline(), carId);
            PacketOnInfo packetOnInfo = PlatManager.getInstance().getPacketOnInfo(trayCode);
            if (packetOnInfo == null) {
                LogUtil.LogDebug(logger, "[SortInfoDecoder] not found trayCode Packet on info! trayCode" + trayCode);
                return;
            }
            SortInfo sortInfo = SortInfoManager.getInstance().createSortInfo();
            sortInfo.setPlatId(packetOnInfo.getPlatId());
            sortInfo.setTrayCode(trayCode);
            sortInfo.setCarId(carId);
            sortInfo.setSorterPipeline(crossSorterInfo.getSorterPipeline());
            sortInfo.setSorterLayer(crossSorterInfo.getSorterLayer());
            byte obr = content[7];
            if (obr != 1 && obr != 2) {
                obr = 1;
            }
            sortInfo.setObr(obr);
            int barcodeNumber = content[8];
            int barcodePosition = 9;
            for (int i = 0; i < barcodeNumber; ++i) {
                byte barcodeLen = content[barcodePosition];
                String barcode = new String(content, ++barcodePosition, (int)barcodeLen, "UTF-8");
                if (BarcodeManager.getInstance().checkBarcodeValid(barcode)) {
                    sortInfo.setBarcode(barcode);
                    sortInfo.getBarcodeList().add(barcode);
                }
                barcodePosition += barcodeLen;
            }
            int plcIdLenPosition = barcodePosition;
            int plcIdPosition = plcIdLenPosition + 1;
            byte plcIdLen = content[plcIdLenPosition];
            byte[] plcIdBuffer = new byte[plcIdLen];
            System.arraycopy(content, plcIdPosition, plcIdBuffer, 0, plcIdLen);
            String plcId = "NoDefine";
            try {
                plcId = new String(plcIdBuffer, "UTF-8");
            }
            catch (Exception e) {
                plcId = "Parse-PLCID-Error";
            }
            sortInfo.setPlcId(plcId);
            int turnNumberPosition = plcIdPosition + plcIdLen;
            byte turnNumber = content[turnNumberPosition];
            sortInfo.setTurnNumber(turnNumber);
            int platIdPosition = turnNumberPosition + 1;
            byte platId = content[platIdPosition];
            sortInfo.setPlatId(String.valueOf(platId));
            if (sortInfo.getBarcode().equals("NoRead")) {
                sortInfo.setCarStatus("unrecognized");
                sortInfo.setBarcode("NoRead");
                sortInfo.getBarcodeList().add("NoRead");
                sortInfo.setErrorCodeSVR(3);
            } else {
                sortInfo.setCarStatus("recognized");
            }
            SortControllerManager.getInstance().onSortInfoMessage(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortInfoDecoder.doDecode] Do decode sort info error : " + ex.toString() + "]");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class DecoderHolder {
        private static final SortInfoDecoder INSTANCE = new SortInfoDecoder();

        private DecoderHolder() {
        }
    }
}

