/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotUnlockDecoder
implements Decoder {
    public static final String NAME = "SlotUnlock";
    protected static final Logger logger = Logger.getLogger(SlotUnlockDecoder.class);
    private static final int SLOT_ID_POSITION = 3;

    public static SlotUnlockDecoder getInstance() {
        return UnlockSlotDecoderHolder.INSTANCE;
    }

    private SlotUnlockDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            int slotIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String slotKey = String.valueOf(slotIdValue);
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotKey);
            if (slotInfo == null) {
                return;
            }
            SortControllerManager.getInstance().onSlotUnlockMessage(slotInfo, channel);
            this.sendSlotUnlockEchoToPLC(content, channel);
        }
        catch (Exception e) {
            LogUtil.LogDebug(logger, "Handle Slot Unlock Frame Content In SlotUnlockDecoder Error -- Exception : " + e.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendSlotUnlockEchoToPLC(byte[] content, Channel channel) {
        SortProtocolCreator.getInstance().sendContentEchoToPLC(content, channel);
    }

    private static class UnlockSlotDecoderHolder {
        private static final SlotUnlockDecoder INSTANCE = new SlotUnlockDecoder();

        private UnlockSlotDecoderHolder() {
        }
    }
}

