/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PlcSyncDecoder
implements Decoder {
    public static final String NAME = "PlcSync";
    protected static final Logger logger = Logger.getLogger(PlcSyncDecoder.class);
    private static final int TIME_BUFFER_POSITION = 3;

    public static PlcSyncDecoder getInstance() {
        return DecoderHolder.INSTANCE;
    }

    private PlcSyncDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            long plcTime = FrameUtils.getInstance().getLongBigEndian(3, content);
            long now = System.currentTimeMillis();
            this.sendToRemoteLogger(plcTime, now);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "EchoTime Decode Catch Exception : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendToRemoteLogger(long plcTime, long now) {
        JSONObject echoTime = new JSONObject();
        String delta = String.valueOf(now - plcTime) + "ms";
        echoTime.put("ServiceName", "EchoTime");
        echoTime.put("plcTime", plcTime);
        echoTime.put("serverTime", now);
        echoTime.put("delta", delta);
        String echoTimeStr = echoTime.toString();
        for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
            JsonChannelManager.getInstance().commitResponse(channel, echoTimeStr.getBytes(), false);
        }
    }

    private static class DecoderHolder {
        private static final PlcSyncDecoder INSTANCE = new PlcSyncDecoder();

        private DecoderHolder() {
        }
    }
}

