/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.CrossSorterInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import java.net.InetSocketAddress;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class PacketOffDecoder
implements Decoder {
    public static final String NAME = "PacketOff";
    protected static final Logger logger = Logger.getLogger(PacketOffDecoder.class);
    private static final int DROPPED_CAR_ID_POSITION = 3;
    private static final int DROPPED_ERROR_CODE_POSITION = 10;
    private static final int DROPPED_PLC_ID_LEN_POSITION = 11;
    private static final int DROPPED_PLC_ID_POSITION = 12;
    private static final int DROPPED_SLOT_ID_POSITION = 8;

    public static PacketOffDecoder getDecoderInstance() {
        return PacketOffDecoderHolder.INSTANCE;
    }

    private PacketOffDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDecode(Channel channel, Object message) {
        byte[] content = (byte[])message;
        InetSocketAddress socketAddress = (InetSocketAddress)channel.getRemoteAddress();
        String clientIP = socketAddress.getAddress().getHostAddress();
        CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByIP(clientIP);
        if (crossSorterInfo == null) {
            LogUtil.LogDebug(logger, "[PacketOffDecoder]: IP not found!  --" + clientIP);
            return;
        }
        int carIdBinary = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
        String carId = String.valueOf(carIdBinary);
        String trayCode = SortProtocolCreator.getInstance().createTrayCode(crossSorterInfo.getSorterPipeline(), carId);
        int droppedSlotId = FrameUtils.getInstance().getUnsignedShortBigEndian(8, content);
        String droppedSlotIdKey = String.valueOf(droppedSlotId);
        byte droppedErrorCode = content[10];
        SortInfo sortInfo = SortInfoManager.getInstance().getSortInfo(trayCode);
        if (sortInfo == null) {
            return;
        }
        sortInfo.setDroppedSlotId(droppedSlotId);
        sortInfo.setErrorCodePLC(droppedErrorCode);
        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(droppedSlotIdKey);
        if (slotInfo != null) {
            sortInfo.setSlotDistrict(slotInfo.getSlotDistrict());
        }
        try {
            byte plcIdLen = content[11];
            String plcId = new String(content, 12, (int)plcIdLen, "UTF-8");
            if (!plcId.equals(sortInfo.getPlcId())) {
                // empty if block
            }
            byte turnNumber = content[12 + plcIdLen];
            Timestamp droppedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            sortInfo.setTimestampPacketOff(droppedTime);
            sortInfo.setTimePacketOff(droppedTime.toString());
            sortInfo.setTurnNumber(turnNumber);
            SortControllerManager.getInstance().onPacketOffMessage(sortInfo);
            SortProtocolCreator.getInstance().sendContentEchoToPLC(content, channel);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Catch an exception in PacketOffCode:" + ex.getMessage());
        }
        finally {
            SortInfoManager.getInstance().removeSortInfo(trayCode);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class PacketOffDecoderHolder {
        private static final PacketOffDecoder INSTANCE = new PacketOffDecoder();

        private PacketOffDecoderHolder() {
        }
    }
}

