/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SorterManager;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.BasicConfig;
import com.simba.server.components.data.CrossSorterInfo;
import com.simba.server.components.data.MachineOps;
import com.simba.server.components.data.SorterStatus;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class MachineStatusDecoder
implements Decoder {
    public static final String NAME = "MachineStatus";
    protected static final Logger logger = Logger.getLogger(MachineStatusDecoder.class);
    private static final int MACHINE_STATUS_POSITION = 3;
    private static final int MACHINE_PAUSE = 3;
    private static final int MACHINE_RUNNING = 5;
    private static final int MACHINE_STARTED = 1;
    private static final int MACHINE_STARTING = 6;
    private static final int MACHINE_STOPPED = 2;
    private static final int MACHINE_WAIT = 4;

    public static MachineStatusDecoder getInstance() {
        return MachineStatusDecoderHolder.INSTANCE;
    }

    private MachineStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            InetSocketAddress socketAddress = (InetSocketAddress)channel.getRemoteAddress();
            String clientIP = socketAddress.getAddress().getHostAddress();
            CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByIP(clientIP);
            if (crossSorterInfo == null) {
                LogUtil.LogDebug(logger, "[MachineStatusDecoder]: IP not found!  --" + clientIP);
                return;
            }
            byte machineStatus = content[3];
            switch (machineStatus) {
                case 1: {
                    SorterParams.getInstance().setMachineStatus("started");
                    this.renewMachineStatus("started");
                    this.SendMachineStatusToServer("start", crossSorterInfo);
                    this.recordMachineAction(1, "started");
                    break;
                }
                case 2: {
                    SorterParams.getInstance().setMachineStatus("stopped");
                    this.renewMachineStatus("stopped");
                    this.SendMachineStatusToServer("stop", crossSorterInfo);
                    this.recordMachineAction(2, "stopped");
                    break;
                }
                case 3: {
                    SorterParams.getInstance().setMachineStatus("pause");
                    this.SendMachineStatusToServer("pause", crossSorterInfo);
                    this.renewMachineStatus("pause");
                    break;
                }
                case 4: {
                    SorterParams.getInstance().setMachineStatus("wait");
                    this.renewMachineStatus("wait");
                    break;
                }
                case 5: {
                    this.renewMachineStatus("running");
                    SorterParams.getInstance().setMachineStatus("running");
                    break;
                }
                case 6: {
                    SorterParams.getInstance().setMachineStatus("starting");
                    break;
                }
                default: {
                    SorterParams.getInstance().setMachineStatus("none");
                }
            }
            SorterParams.getInstance().setRecvHeartBeatTime(System.currentTimeMillis());
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "MachineStatus Decode Catch Exception : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return null;
    }

    private void recordMachineAction(int opsType, String opsDesc) {
        try {
            MachineOps machineOps = new MachineOps();
            machineOps.setWorkerNo("none");
            machineOps.setOpsType(opsType);
            machineOps.setOpsDesc(opsDesc);
            ICommand command = CommandCreator.getInstance().createCommand("RecordMachineOpsCmd", machineOps);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Record machine action catch exception : " + ex.getMessage());
        }
    }

    private void renewMachineStatus(String value) {
        String machineStatus = SorterParams.getInstance().getMachineStatus();
        if (machineStatus.equals("running") && value.equals("running")) {
            return;
        }
        BasicConfig basicConfig = new BasicConfig();
        basicConfig.setBasicKey("runStatus");
        basicConfig.setBasicValue(value);
        ICommand command = CommandCreator.getInstance().createCommand("RenewBasicConfigCmd", basicConfig);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void SendMachineStatusToServer(String value, CrossSorterInfo crossSorterInfo) {
        SorterStatus sorterStatus = new SorterStatus();
        sorterStatus.setStatus(value);
        sorterStatus.setPipeline(crossSorterInfo.getSorterPipeline());
        ICommand command = CommandCreator.getInstance().createCommand("WebMachineStatusUploadCmd", sorterStatus);
        Boolean res = WebCommandExecutor.getInstance().executeCmd(command);
        if (!res.booleanValue()) {
            LogUtil.LogError(logger, "[MachineStatusDecoder] Send Machine Status To Server Failed!");
        }
    }

    private static class MachineStatusDecoderHolder {
        private static MachineStatusDecoder INSTANCE = new MachineStatusDecoder();

        private MachineStatusDecoderHolder() {
        }
    }
}

