/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PlatManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.CrossSorterInfo;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.ISortInfoController;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SortInfoController
implements ISortInfoController {
    private static final Logger logger = Logger.getLogger(SortInfoController.class);

    @Override
    public void onSortInfoMessage(SortInfo sortInfo) {
        try {
            if (sortInfo == null) {
                return;
            }
            sortInfo.setScannedMode("OBR");
            sortInfo.setScannedPlatType("AUTO");
            String trayCode = sortInfo.getTrayCode();
            if (trayCode == null || trayCode.equals("")) {
                return;
            }
            this.recordPackOnInfo(sortInfo);
            SortInfoManager.getInstance().addSortInfo(sortInfo);
            this.setSortInfoObrScanTime(sortInfo);
            byte[] sortResultBuffer = null;
            int errorCode = sortInfo.getErrorCodeSVR();
            if (errorCode == 3) {
                SortInfoManager.getInstance().doHandleNoRead(sortInfo);
            } else {
                ICommand command = CommandCreator.getInstance().createCommand("WebSortInfoCmd", sortInfo);
                Boolean res = WebCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue()) {
                    this.printWebCmdErrorLog(sortInfo);
                }
                SortInfoManager.getInstance().handleSortInfoResult(sortInfo);
            }
            sortResultBuffer = SortProtocolCreator.getInstance().createSortCmdWithCarID(sortInfo);
            String pipeline = sortInfo.getSorterPipeline();
            this.sendToPlcChannel(sortResultBuffer, pipeline);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortInfoController.onSortInfoMessage] Handle Sort Info Error:" + ex.getMessage());
        }
    }

    private void printWebCmdErrorLog(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        LogUtil.LogError(logger, "[SortInfoController.printWebCmdErrorLog] billCode : [" + barcode + "] errorCode : [" + sortInfo.getErrorCodeSVR() + "]");
    }

    private void recordPackOnInfo(SortInfo sortInfo) {
        String carId = sortInfo.getCarId();
        String trayCode = SortProtocolCreator.getInstance().createTrayCode(sortInfo.getSorterPipeline(), carId);
        PacketOnInfo packetOnInfo = PlatManager.getInstance().getPacketOnInfo(trayCode);
        if (packetOnInfo != null) {
            sortInfo.setPlatId(packetOnInfo.getPlatId());
            sortInfo.setPlatMode(packetOnInfo.getPlatMode());
            packetOnInfo.setBarcode(sortInfo.getBarcode());
            packetOnInfo.setScannedMode(sortInfo.getScannedMode());
            packetOnInfo.setScannedPlatType(sortInfo.getScannedPlatType());
            PlatManager.getInstance().removePacketOnInfo(trayCode);
            ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOnCmd", packetOnInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
    }

    private void sendToPlcChannel(byte[] sortResultBuffer, String pipeline) {
        try {
            CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByPipeline(pipeline);
            if (crossSorterInfo == null) {
                LogUtil.LogDebug(logger, "[SortInfoController]: Pipeline not found!  --" + pipeline);
                return;
            }
            Channel tmpChannel = crossSorterInfo.getSorterChannel();
            FrameChannelManager.getInstance().commitResponse(tmpChannel, sortResultBuffer, false);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortInfoController]:[sendToPlcChannel] ,[Message]:[Send sort result to plc channels error : " + ex.getMessage() + "]");
        }
    }

    private void setSortInfoObrScanTime(SortInfo sortInfo) {
        Timestamp obrScannedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
        sortInfo.setTimestampScanned(obrScannedTime);
        sortInfo.setTimeScanned(obrScannedTime.toString());
    }
}

