/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.log.LogUtil;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotUnlockController;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotUnlockController
implements ISlotUnlockController {
    private static final Logger logger = Logger.getLogger(SlotUnlockController.class);

    @Override
    public void onSlotUnlockMessage(SlotInfo slotInfo, Channel channel) {
        try {
            Boolean res = SlotManager.getInstance().checkSlotIsTrash(slotInfo.getSlotId());
            if (res.booleanValue()) {
                slotInfo.setLockStatus(0);
                SlotManager.getInstance().setSlotSoftLockStatus(slotInfo);
                SlotManager.getInstance().sendSlotSoftUnLockToPLC(slotInfo, channel);
                return;
            }
            SlotManager.getInstance().doAllocBoxInfo(slotInfo, channel);
        }
        catch (Exception ex) {
            LogUtil.LogDebug(logger, "[SlotUnlockController] Handle Slot Unlock Message In SlotUnlockController Error -- Exception : " + ex);
        }
    }
}

