/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotPackController;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotPackController
implements ISlotPackController {
    private static final Logger logger = Logger.getLogger(SlotPackController.class);

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo, Channel channel) {
        Boolean res = false;
        try {
            slotInfo.setLockStatus(1);
            SlotManager.getInstance().setSlotSoftLockStatus(slotInfo);
            SlotManager.getInstance().sendSlotSoftLockToPLC(slotInfo, channel);
            this.printSlotPackPoint("start", slotInfo);
            res = SlotManager.getInstance().checkSlotIsTrash(slotInfo.getSlotId());
            if (res.booleanValue()) {
                return;
            }
            String boxCode = slotInfo.getBoxInfo().getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                LogUtil.LogDebug(logger, "[SlotPackController] Slot Box Code Is Null : [" + slotInfo.getSlotId() + "]");
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("FetchPacketCountCmd", slotInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotPackController] Query Packet Off Count In SlotPackProcess Failed! ");
                SlotManager.getInstance().offerSlotPackToRestore(slotInfo);
                return;
            }
            if (slotInfo.getBoxInfo().getMailCount() == 0) {
                LogUtil.LogDebug(logger, "[SlotPackController] Query Packet Off Count is Zero.");
                return;
            }
            Timestamp createTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            slotInfo.getBoxInfo().setCreateTime(createTime.toString());
            command = CommandCreator.getInstance().createCommand("RecordBoxPackCmd", slotInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotPackController] Insert Slot Pack Record In SlotPackController Failed! ");
                SlotManager.getInstance().offerSlotPackToRestore(slotInfo);
                return;
            }
            this.printSlotPackPoint("end", slotInfo);
            slotInfo.resetBoxInfo();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SlotPackController] Handle Slot Pack Message In SlotPackController Error -- Exception : " + ex);
        }
    }

    private void printSlotPackPoint(String point, SlotInfo slotInfo) {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("[SlotPackController.onSlotPackMessage] Slot:[");
        boxInfoBuilder.append(slotInfo.getChuteCode());
        boxInfoBuilder.append("],Pack Box Code:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getBoxCode());
        boxInfoBuilder.append("],mailCount:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getMailCount());
        boxInfoBuilder.append("],point:[");
        boxInfoBuilder.append(point);
        boxInfoBuilder.append("]");
        LogUtil.LogDebug(logger, boxInfoBuilder.toString());
    }
}

