/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IPlatScannedController;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class PlatScannedController
implements IPlatScannedController {
    private static final Logger logger = Logger.getLogger(PlatScannedController.class);

    @Override
    public void onPlatScannedMessage(SortInfo sortInfo) {
        try {
            sortInfo.getBarcode();
            String scannedPlatType = sortInfo.getScannedPlatType();
            if (scannedPlatType.equals("MANUAL")) {
                this.requestWeighing(sortInfo);
            } else {
                this.requestSortInfo(sortInfo);
            }
            this.restoreScannedInfo(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Request Sort Info Error -- Exception : " + ex);
        }
    }

    private void printWebSortInfoError(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        LogUtil.LogError(logger, "[PlatScannedController.printWebSortInfoError] billCode : [" + barcode + "] errorCode : [" + sortInfo.getErrorCodeSVR() + "]");
    }

    private void requestSortInfo(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("WebSortInfoCmd", sortInfo);
            Boolean res = WebCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                this.printWebSortInfoError(sortInfo);
            }
            SortInfoManager.getInstance().handleSortInfoResult(sortInfo);
            this.sendScannedResultToPLC(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Request Sort Info Error -- Exception : " + ex);
        }
    }

    private void requestWeighing(SortInfo sortInfo) {
        try {
            this.sendScannedResultToPLC(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PlatScannedController.requestWeighing] : Error -- Exception : " + ex);
        }
    }

    private void restoreScannedInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("RecordPlatScannedCmd", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendScannedResultToPLC(SortInfo sortInfo) {
        Channel[] clients;
        byte[] replyBuffer = SortProtocolCreator.getInstance().createSortCmdWithPlat(sortInfo);
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(client, replyBuffer, false);
        }
    }
}

