/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.controllers.IPacketOnController;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PacketOnController
implements IPacketOnController {
    private static final Logger logger = Logger.getLogger(PacketOnController.class);
    private static final int PACKET_ON_MODE_SCANNED = 3;

    @Override
    public void onPacketOnMessage(PacketOnInfo packetOnInfo, Channel channel) {
        try {
            int modeBinary = packetOnInfo.getPlatModeValue();
            String platId = packetOnInfo.getPlatId();
            String carId = packetOnInfo.getCarId();
            String barcode = packetOnInfo.getBarcode();
            String mode = packetOnInfo.getPlatMode();
            String trayCode = packetOnInfo.getTrayCode();
            byte[] content = packetOnInfo.getContent();
            if (modeBinary == 3) {
                PlatInstance platInstance = PlatManager.getInstance().getPlatById(platId);
                if (platInstance == null) {
                    return;
                }
                platInstance.handlePacketOnCommand(packetOnInfo);
                this.restorePacketOnInfo(packetOnInfo);
            } else {
                PlatManager.getInstance().addPacketOnInfo(trayCode, packetOnInfo);
            }
            this.sendPacketOnInfoToClient(carId, platId, mode, barcode, trayCode);
            this.printPacketOnInfo(packetOnInfo);
            this.sendPacketEchoToPlc(content, channel);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Packet On Message In PacketOn Handler Error -- Exception : " + ex);
        }
    }

    private void printPacketOnInfo(PacketOnInfo packetOnInfo) {
        try {
            StringBuilder info = new StringBuilder("[PacketOnController] -- ");
            info.append("[carId:");
            info.append(packetOnInfo.getCarId());
            info.append("],[PlatId:");
            info.append(packetOnInfo.getPlatId());
            info.append("],[trayCode:");
            info.append(packetOnInfo.getTrayCode());
            info.append("]");
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void restorePacketOnInfo(PacketOnInfo packetOnInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOnCmd", packetOnInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendPacketEchoToPlc(byte[] content, Channel channel) {
        SortProtocolCreator.getInstance().sendContentEchoToPLC(content, channel);
    }

    private void sendPacketOnInfoToClient(String carId, String platId, String mode, String barcode, String trayCode) {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "PacketOnInfo");
            sortInfoObj.put("carId", carId);
            sortInfoObj.put("platId", platId);
            sortInfoObj.put("platMode", mode);
            sortInfoObj.put("barcode", barcode);
            sortInfoObj.put("trayCode", trayCode);
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PacketOnController.sendPacketOnInfoToClient],[Packet on info send to remote logger error : " + ex.getMessage() + "]");
        }
    }
}

