/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortResult;
import com.simba.server.controllers.IPacketOffController;
import org.apache.log4j.Logger;

public class PacketOffController
implements IPacketOffController {
    private static final Logger logger = Logger.getLogger(PacketOffController.class);

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        try {
            this.offerSortResult(sortInfo);
            this.restorePacketOff(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle PacketOff Message In BestPacketOff Handler Error -- Exception : " + ex);
        }
    }

    private Boolean offerSortResult(SortInfo sortInfo) {
        Boolean ret = false;
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            int errorCodeSVR = sortInfo.getErrorCodeSVR();
            if (errorCodeSVR > 0) {
                sortInfo.setUploadFlag(2);
            }
            if (SlotManager.getInstance().checkSlotIsTrash(slotId).booleanValue()) {
                return ret;
            }
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return ret;
            }
            SortResult sortResult = new SortResult();
            String boxCode = slotInfo.getBoxInfo().getBoxCode();
            sortResult.setBoxCode(boxCode);
            sortResult.setSlotId(slotInfo.getSlotId());
            sortResult.getSortInfos().add(sortInfo);
            sortInfo.setBoxCode(boxCode);
            int uploadNum = sortInfo.getUploadNum() + 1;
            String sortPortCode = SortProtocolCreator.getInstance().createSortPortCode(sortInfo);
            sortInfo.setSortPortCode(sortPortCode);
            String parcelCode = SortProtocolCreator.getInstance().createParcelCode(sortInfo.getSorterPipeline(), sortInfo.getPlatId());
            sortInfo.setParcelCode(parcelCode);
            ICommand command = CommandCreator.getInstance().createCommand("WebPacketOffCmd", sortResult);
            ret = WebCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue()) {
                sortInfo.setUploadFlag(1);
            } else {
                sortInfo.setUploadFlag(0);
            }
            sortInfo.setUploadNum(uploadNum);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle PacketOff Message In uploadSortInfo Handler Error -- Exception : " + ex);
            ret = false;
        }
        return ret;
    }

    private void restorePacketOff(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOffCmd", sortInfo);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                ServerManager.getInstance().getDataRestoreTask().offerRestoreDataToQueue(sortInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle PacketOff Message In restorePacketOff Handler Error -- Exception : " + ex);
        }
    }
}

