/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.data;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.IRecordData;
import java.sql.Timestamp;
import java.util.UUID;
import org.apache.log4j.Logger;

public class SlotInfo
implements IRecordData {
    private static final Logger logger = Logger.getLogger(SlotInfo.class);
    private Boolean allocBoxInfo = false;
    private int lockStatus;
    private final BoxInfo boxInfo = new BoxInfo();
    private String slotId;
    private String chuteCode;
    private int needUpload;
    private int slotDistrict;

    public void resetBoxInfo() {
        this.allocBoxInfo = false;
        this.boxInfo.setBoxCode(this.CreateBoxCode());
        this.boxInfo.setBoxType("AutoCreate");
        this.boxInfo.setMailCount(0);
    }

    private String CreateBoxCode() {
        String boxCode = UUID.randomUUID().toString().toUpperCase();
        return boxCode;
    }

    public void cloneSlotInfo(SlotInfo toSlotInfo) {
        this.slotDistrict = toSlotInfo.getSlotDistrict();
        this.slotId = toSlotInfo.getSlotId();
        this.chuteCode = toSlotInfo.getChuteCode();
        this.needUpload = toSlotInfo.getNeedUpload();
        this.boxInfo.setBoxCode(toSlotInfo.getBoxInfo().getBoxCode());
        this.boxInfo.setBoxType(toSlotInfo.getBoxInfo().getBoxType());
        this.boxInfo.setMailCount(toSlotInfo.getBoxInfo().getMailCount());
    }

    public Boolean getAllocBoxInfo() {
        return this.allocBoxInfo;
    }

    public void setAllocBoxInfo(Boolean status) {
        this.allocBoxInfo = status;
    }

    public int getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(int lockStatus) {
        this.lockStatus = lockStatus;
    }

    public BoxInfo getBoxInfo() {
        return this.boxInfo;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public String getChuteCode() {
        return this.chuteCode;
    }

    public void setChuteCode(String chuteCode) {
        this.chuteCode = chuteCode;
    }

    public int getNeedUpload() {
        return this.needUpload;
    }

    public void setNeedUpload(int needUpload) {
        this.needUpload = needUpload;
    }

    public int getSlotDistrict() {
        return this.slotDistrict;
    }

    public void setSlotDistrict(int slotDistrict) {
        this.slotDistrict = slotDistrict;
    }

    @Override
    public String getRecordDataName() {
        return "Slot-Pack-Restore-Info";
    }

    @Override
    public void restoreData() {
        Boolean res = false;
        try {
            LogUtil.LogDebug(logger, "[SlotInfo.restoreData] Try Restore Slot Pack Again. [BoxCode:" + this.boxInfo.getBoxCode() + "]");
            res = SlotManager.getInstance().checkSlotIsTrash(this.getSlotId());
            if (res.booleanValue()) {
                return;
            }
            String boxCode = this.getBoxInfo().getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                LogUtil.LogDebug(logger, "[SlotInfo.restoreData] Slot Box Code Is Null : [" + this.getSlotId() + "]");
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("FetchPacketCountCmd", this);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotInfo.restoreData] Query Packet Off Count In SlotInfo Failed ");
                return;
            }
            if (this.getBoxInfo().getMailCount() == 0) {
                LogUtil.LogDebug(logger, "[SlotInfo.restoreData] Query Packet Off Count is Zero");
                return;
            }
            Timestamp createTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            this.getBoxInfo().setCreateTime(createTime.toString());
            command = CommandCreator.getInstance().createCommand("RecordBoxPackCmd", this);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotInfo.restoreData] Insert Slot Pack Record In SlotInfo Failed ");
                return;
            }
            this.resetBoxInfo();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SlotInfo.restoreData] Handle Slot Pack Message In SlotInfo Error -- Exception : " + ex);
        }
    }
}

