/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.GlobalParam;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.components.data.CrossSorterInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class SorterManager {
    private static final Logger logger = Logger.getLogger(SorterManager.class);
    private final ConcurrentHashMap<String, CrossSorterInfo> crossSorters = new ConcurrentHashMap();
    private String configFile;
    private String configFilePath;

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public static SorterManager getInstance() {
        return PlcManagerHolder.INSTANCE;
    }

    private SorterManager() {
    }

    public void init(String _configFile) {
        this.setConfigFile(_configFile);
        this.setConfigFilePath("etc" + GlobalParam.PATH_SEP + this.configFile);
        try {
            Document rootDoc = ServerManager.getInstance().getXmlDocFromFile(new File(this.configFilePath));
            Element root = rootDoc.getRootElement();
            Element rootElement = root.getChild("Sorters");
            List<Element> client = rootElement.getChildren();
            for (Element element : client) {
                String id = element.getAttributeValue("id");
                String ip = element.getAttributeValue("ip");
                String machine = element.getAttributeValue("name");
                String layer = element.getAttributeValue("layer");
                String pipeline = element.getAttributeValue("pipeline");
                CrossSorterInfo info = new CrossSorterInfo();
                info.setSorterName(machine);
                info.setSorterAddr(ip);
                info.setSorterLayer(Integer.parseInt(layer));
                info.setSorterPipeline(pipeline);
                this.crossSorters.put(id, info);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Init PLC Clients Manager Error -- Exception : " + ex);
        }
    }

    public CrossSorterInfo getCrossSorterByIP(String address) {
        for (Map.Entry<String, CrossSorterInfo> infoEmpty : this.crossSorters.entrySet()) {
            if (!infoEmpty.getValue().getSorterAddr().equals(address)) continue;
            CrossSorterInfo crossSorterInfo = infoEmpty.getValue();
            return crossSorterInfo;
        }
        return null;
    }

    public CrossSorterInfo getCrossSorterByPipeline(String pipeline) {
        for (Map.Entry<String, CrossSorterInfo> infoEmpty : this.crossSorters.entrySet()) {
            if (!infoEmpty.getValue().getSorterPipeline().equals(pipeline)) continue;
            CrossSorterInfo crossSorterInfo = infoEmpty.getValue();
            return crossSorterInfo;
        }
        return null;
    }

    private static class PlcManagerHolder {
        private static final SorterManager INSTANCE = new SorterManager();

        private PlcManagerHolder() {
        }
    }
}

