/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.MachineParams;
import com.simba.server.components.SortCommonDefines;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortResult;
import com.simba.server.components.data.SorterStatus;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.json.JSONObject;

public class SortProtocolCreator {
    private static final Logger logger = Logger.getLogger(SortProtocolCreator.class);
    private static final int MACHINE_PARAMS_SEND_BUFFER_SIZE = 30;
    private static final byte PLAT_MODE_SCANNED = 3;
    private static final int RESET_PLAT_RESULT_BUFFER_SIZE = 15;
    private static final int SLOT_SOFT_LOCK_CONSTANT_SIZE = 17;
    private static final int SORT_CMD_CONSTANT_BUFFER_SIZE = 28;
    private static final int TSH_SLOTS_SEND_BUFFER_SIZE = 20;
    private final Map<Integer, String> errorCodesMap = new HashMap<Integer, String>();

    public static SortProtocolCreator getInstance() {
        return SortProtocolManagerHolder.INSTANCE;
    }

    private SortProtocolCreator() {
    }

    public Timestamp createCurrentTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public byte[] createMachineParams() {
        byte[] replyBuffer = null;
        try {
            int bufferSize = 30;
            replyBuffer = new byte[bufferSize];
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{38};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            int maxLoopCircles = MachineParams.getInstance().getMaxLoopCircles();
            byte[] maxLoopCirclesBuf = new byte[]{(byte)maxLoopCircles};
            System.arraycopy(maxLoopCirclesBuf, 0, replyBuffer, position += command.length, maxLoopCirclesBuf.length);
            int maxScanTimes = MachineParams.getInstance().getMaxScanTimes();
            byte[] maxScanTimesBuf = new byte[]{(byte)maxScanTimes};
            System.arraycopy(maxScanTimesBuf, 0, replyBuffer, position += maxLoopCirclesBuf.length, maxScanTimesBuf.length);
            int clearMode = MachineParams.getInstance().getClearMode();
            byte[] clearModeBuf = new byte[]{(byte)clearMode};
            System.arraycopy(clearModeBuf, 0, replyBuffer, position += maxScanTimesBuf.length, clearModeBuf.length);
            int sorterMaintainSpeed = MachineParams.getInstance().getSorterSpeed();
            byte[] sorterMaintainSpeedBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, sorterMaintainSpeed, sorterMaintainSpeedBuf);
            System.arraycopy(sorterMaintainSpeedBuf, 0, replyBuffer, position += clearModeBuf.length, sorterMaintainSpeedBuf.length);
            int startWarnTime = MachineParams.getInstance().getStartWarnTime();
            byte[] startWarnTimeBuf = new byte[]{(byte)startWarnTime};
            System.arraycopy(startWarnTimeBuf, 0, replyBuffer, position += sorterMaintainSpeedBuf.length, startWarnTimeBuf.length);
            int clearStopTime = MachineParams.getInstance().getClearStopTime();
            byte[] clearStopTimeBuf = new byte[]{(byte)clearStopTime};
            System.arraycopy(clearStopTimeBuf, 0, replyBuffer, position += startWarnTimeBuf.length, clearStopTimeBuf.length);
            int clearStopCircles = MachineParams.getInstance().getClearStopCircles();
            byte[] clearStopCirclesBuf = new byte[]{(byte)clearStopCircles};
            System.arraycopy(clearStopCirclesBuf, 0, replyBuffer, position += clearStopTimeBuf.length, clearStopCirclesBuf.length);
            int noreadWarn = MachineParams.getInstance().getNoreadWarn();
            byte[] noreadWarnBuf = new byte[]{(byte)noreadWarn};
            System.arraycopy(noreadWarnBuf, 0, replyBuffer, position += clearStopCirclesBuf.length, noreadWarnBuf.length);
            int saveElecTime = MachineParams.getInstance().getSaveElecTime();
            byte[] saveElecTimeBuf = new byte[]{(byte)saveElecTime};
            System.arraycopy(saveElecTimeBuf, 0, replyBuffer, position += noreadWarnBuf.length, saveElecTimeBuf.length);
            int pidaiInterval = MachineParams.getInstance().getPidaiInterval();
            byte[] pidaiIntervalBuf = new byte[]{(byte)pidaiInterval};
            System.arraycopy(pidaiIntervalBuf, 0, replyBuffer, position += saveElecTimeBuf.length, pidaiIntervalBuf.length);
            int pidaiCheckTime = MachineParams.getInstance().getPidaiCheckTime();
            byte[] pidaiCheckTimeBuf = new byte[]{(byte)pidaiCheckTime};
            System.arraycopy(pidaiCheckTimeBuf, 0, replyBuffer, position += pidaiIntervalBuf.length, pidaiCheckTimeBuf.length);
            byte[] timeBuffer = FrameUtils.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position += pidaiCheckTimeBuf.length, timeBuffer.length);
            position += timeBuffer.length;
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, replyBuffer.length - 3, serialByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, replyBuffer.length - 2, replayEnder.length);
            int n = (position += serialByte.length) + replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortCommandManager.sendMachineParams] Create Machine Params Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createResetPlatBuffer(int platId) {
        byte[] replyBuffer = new byte[15];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{14};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] platformId = new byte[]{(byte)platId};
        System.arraycopy(platformId, 0, replyBuffer, position += command.length, platformId.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += platformId.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSortCmdWithCarID(SortInfo sortInfo) {
        int slotsNum = sortInfo.getSlotsList().size();
        int bufferLen = 28 + 2 * slotsNum;
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{7};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            int carId = Integer.parseInt(sortInfo.getCarId());
            byte[] carIdBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, carId, carIdBuf);
            System.arraycopy(carIdBuf, 0, replyBuffer, position += command.length, carIdBuf.length);
            int obr = sortInfo.getObr();
            byte[] obrBuf = new byte[]{(byte)obr};
            System.arraycopy(obrBuf, 0, replyBuffer, position += carIdBuf.length, obrBuf.length);
            byte[] siteCodeBuf = new byte[2];
            int siteCodeValue = sortInfo.getSiteCodeValue();
            FrameUtils.getInstance().setShortBigEndian(0, siteCodeValue, siteCodeBuf);
            System.arraycopy(siteCodeBuf, 0, replyBuffer, position += obrBuf.length, siteCodeBuf.length);
            byte[] slotsNumBuffer = new byte[]{(byte)slotsNum};
            System.arraycopy(slotsNumBuffer, 0, replyBuffer, position += siteCodeBuf.length, slotsNumBuffer.length);
            position += slotsNumBuffer.length;
            for (int slot : sortInfo.getSlotsList()) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            int sortMode = 0;
            try {
                sortMode = Integer.parseInt(sortInfo.getSortMode());
            }
            catch (Exception e) {
                sortMode = 0;
            }
            byte[] sortModeBuf = new byte[]{(byte)sortMode};
            System.arraycopy(sortModeBuf, 0, replyBuffer, position, sortModeBuf.length);
            byte[] svrErrorCodeBuff = new byte[]{(byte)sortInfo.getErrorCodeSVR()};
            System.arraycopy(svrErrorCodeBuff, 0, replyBuffer, position += sortModeBuf.length, svrErrorCodeBuff.length);
            byte[] timeStampBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(timeStampBuffer, 0, replyBuffer, position += svrErrorCodeBuff.length, timeStampBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortCommandManager.createSortInfoBuffer] Create Sort Info Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createSlotSoftLock(int slotId) {
        int bufferLen = 17;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{18};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotId, slotIdBuf);
        System.arraycopy(slotIdBuf, 0, replyBuffer, position += command.length, slotIdBuf.length);
        byte[] slotLockStatus = new byte[]{1};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += slotIdBuf.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSlotSoftUnLock(int slotId) {
        int bufferLen = 17;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{19};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotId, slotIdBuf);
        System.arraycopy(slotIdBuf, 0, replyBuffer, position += command.length, slotIdBuf.length);
        boolean slotUnlock = false;
        byte[] slotLockStatus = new byte[]{(byte)(slotUnlock ? 1 : 0)};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += slotIdBuf.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSortCmdWithPlat(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        if (barcode == null) {
            barcode = "NoneCode";
        }
        int slotsNum = sortInfo.getSlotsList().size();
        int barcodeLen = barcode.length();
        int bufferLen = 28 + barcodeLen + 2 * slotsNum;
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{4};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] platId = new byte[]{(byte)Integer.parseInt(sortInfo.getPlatId())};
            System.arraycopy(platId, 0, replyBuffer, position += command.length, platId.length);
            byte[] platMode = new byte[]{3};
            System.arraycopy(platMode, 0, replyBuffer, position += platId.length, platMode.length);
            byte[] barcodeLenBuf = new byte[]{(byte)barcodeLen};
            System.arraycopy(barcodeLenBuf, 0, replyBuffer, position += platMode.length, barcodeLenBuf.length);
            byte[] barcodeBuf = barcode.getBytes();
            System.arraycopy(barcodeBuf, 0, replyBuffer, position += barcodeLenBuf.length, barcodeBuf.length);
            byte[] siteCodeBuf = new byte[2];
            int siteCodeValue = sortInfo.getSiteCodeValue();
            FrameUtils.getInstance().setShortBigEndian(0, siteCodeValue, siteCodeBuf);
            System.arraycopy(siteCodeBuf, 0, replyBuffer, position += barcodeBuf.length, siteCodeBuf.length);
            byte[] slotsNumBuf = new byte[]{(byte)slotsNum};
            System.arraycopy(slotsNumBuf, 0, replyBuffer, position += siteCodeBuf.length, slotsNumBuf.length);
            position += slotsNumBuf.length;
            for (int slot : sortInfo.getSlotsList()) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            int sortMode = 0;
            try {
                sortMode = Integer.parseInt(sortInfo.getSortMode());
            }
            catch (Exception e) {
                sortMode = 0;
            }
            byte[] sortModeBuf = new byte[]{(byte)sortMode};
            System.arraycopy(sortModeBuf, 0, replyBuffer, position, sortModeBuf.length);
            byte[] svrErrorCodeBuff = new byte[]{(byte)sortInfo.getErrorCodeSVR()};
            System.arraycopy(svrErrorCodeBuff, 0, replyBuffer, position += sortModeBuf.length, svrErrorCodeBuff.length);
            byte[] scannedTimeBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(scannedTimeBuffer, 0, replyBuffer, position += svrErrorCodeBuff.length, scannedTimeBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += scannedTimeBuffer.length, finalByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortProtocolCreator.createSortInfoWithPlat] Create Sort Info Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public String createSortInfoResult(SortInfo sortInfo) {
        JSONObject requestObj = new JSONObject();
        ArrayList<String> barcodeList = new ArrayList<String>();
        barcodeList.add(sortInfo.getBarcode());
        requestObj.put("sortingId", sortInfo.getSortingId());
        requestObj.put("trayCode", sortInfo.getTrayCode());
        requestObj.put("trayStatus", sortInfo.getCarStatus());
        requestObj.put("billCodes", barcodeList);
        requestObj.put("pipeline", sortInfo.getSorterPipeline());
        requestObj.put("sortingId", sortInfo.getSortingId());
        requestObj.put("turnNumber", sortInfo.getTurnNumber());
        requestObj.put("requestTime", sortInfo.getTimestampScanned().getTime());
        requestObj.put("sortMode", MachineParams.getInstance().getSortMode());
        return requestObj.toString();
    }

    public String createSortResult(SortResult sortResult) {
        if (sortResult == null || sortResult.getSortInfos().size() == 0) {
            return null;
        }
        SortInfo sortInfo = sortResult.getSortInfos().get(0);
        JSONObject requestObj = new JSONObject();
        requestObj.put("sortingId", sortInfo.getSortingId());
        requestObj.put("trayCode", sortInfo.getTrayCode());
        requestObj.put("billCode", sortInfo.getBarcode());
        requestObj.put("pipeline", sortInfo.getSorterPipeline());
        requestObj.put("sortTime", Timestamp.valueOf(sortInfo.getTimePacketOff()));
        requestObj.put("turnNumber", sortInfo.getTurnNumber());
        requestObj.put("sortPortCode", sortInfo.getSortPortCode());
        requestObj.put("parcelCode", sortInfo.getParcelCode());
        requestObj.put("sortSource", sortInfo.getSortSource());
        requestObj.put("sortCode", sortInfo.getSortCode());
        requestObj.put("sortMode", MachineParams.getInstance().getSortMode());
        return requestObj.toString();
    }

    public String createMachineStatusResult(SorterStatus sorterStatus) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("pipeline", sorterStatus.getPipeline());
        long now = System.currentTimeMillis();
        requestObj.put("switchTime", now);
        requestObj.put("status", sorterStatus.getStatus());
        requestObj.put("sortMode", MachineParams.getInstance().getSortMode());
        return requestObj.toString();
    }

    public String createUploadWeightResult(PacketOnInfo packetOnInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("pipeline", packetOnInfo.getPlatId());
        long now = System.currentTimeMillis();
        requestObj.put("switchTime", now);
        requestObj.put("status", packetOnInfo.getCarId());
        requestObj.put("sortMode", MachineParams.getInstance().getSortMode());
        return requestObj.toString();
    }

    public String createTrayCode(String sorterPipeline, String carId) {
        String trayCode;
        try {
            sorterPipeline = sorterPipeline.substring(sorterPipeline.length() - 1);
            String strCarId = String.format("%03d", Integer.valueOf(carId));
            trayCode = sorterPipeline + strCarId;
        }
        catch (Exception ex) {
            trayCode = sorterPipeline + "000";
        }
        return trayCode;
    }

    public String createSortPortCode(SortInfo sortInfo) {
        String sortPortCode;
        try {
            String sorterPipeline = sortInfo.getSorterPipeline();
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String strDroppedSlotId = String.format("%03d", droppedSlotId);
            sortPortCode = sorterPipeline + strDroppedSlotId;
        }
        catch (Exception ex) {
            sortPortCode = sortInfo.getSorterPipeline() + "000";
        }
        return sortPortCode;
    }

    public String createParcelCode(String SorterPipeline, String PlatId) {
        String ParcelCode;
        try {
            String platIdCode = PlatId;
            if (platIdCode == null || platIdCode.equals("")) {
                platIdCode = "0";
            }
            String platId = String.format("%02d", Integer.valueOf(platIdCode));
            ParcelCode = SorterPipeline + platId;
        }
        catch (Exception ex) {
            ParcelCode = SorterPipeline + "00";
        }
        return ParcelCode;
    }

    public byte[] createSystemTimeToBuffer() {
        byte[] timeBuffer = new byte[8];
        long now = System.currentTimeMillis();
        FrameUtils.getInstance().setLongBigEndian(0, now, timeBuffer);
        return timeBuffer;
    }

    public void doSendTshSlotsToPLC(List<Integer> tshSlots, int tshValue) {
        try {
            Channel[] channels;
            if (tshSlots == null) {
                return;
            }
            int factualSize = tshSlots.size();
            int bufferSize = 20 + 2 * factualSize;
            byte[] replyBuffer = new byte[bufferSize];
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{-16};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] tshVlaueBuf = new byte[]{(byte)tshValue};
            System.arraycopy(tshVlaueBuf, 0, replyBuffer, position += command.length, tshVlaueBuf.length);
            int slotCount = tshSlots.size();
            byte[] slotCountBuf = new byte[]{(byte)slotCount};
            System.arraycopy(slotCountBuf, 0, replyBuffer, position += tshVlaueBuf.length, slotCountBuf.length);
            position += slotCountBuf.length;
            for (int slot : tshSlots) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            byte[] timeBuffer = FrameUtils.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position, timeBuffer.length);
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, position += timeBuffer.length, serialByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
            position += replayEnder.length;
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortProtocolCreator.doSendTshSlotsToPLC] Send sort plan items error:");
        }
    }

    public void init() {
    }

    public void sendContentEchoToPLC(byte[] content, Channel channel) {
        if (content == null || content.length < 2) {
            return;
        }
        content[0] = 2;
        content[1] = 1;
        Channel tmpChannel = channel;
        FrameChannelManager.getInstance().commitResponse(tmpChannel, content, false);
    }

    public void shutdown() {
    }

    public HttpResponse createHttpResponse(HttpRequest request, String strResponseJson) {
        CookieDecoder cookieDecoder;
        Set<Cookie> cookies;
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        DynamicChannelBuffer responseContent = new DynamicChannelBuffer(strResponseJson.getBytes().length);
        responseContent.writeBytes(strResponseJson.getBytes());
        String cookieString = request.getHeader("Cookie");
        if (cookieString != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", cookieEncoder.encode());
        }
        response.setHeader("Content-Type", "application/json");
        response.setHeader("Content-Encoding", "UTF-8");
        response.setStatus(HttpResponseStatus.OK);
        response.setContent(responseContent);
        return response;
    }

    private static class SortProtocolManagerHolder {
        private static final SortProtocolCreator INSTANCE = new SortProtocolCreator();

        private SortProtocolManagerHolder() {
        }
    }
}

