/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SortInfo;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SortInfoManager {
    protected static final Logger logger = Logger.getLogger(SortInfoManager.class);
    private final ConcurrentHashMap<String, Integer> siteCodeMap = new ConcurrentHashMap();
    private final AtomicInteger siteCodeSerial = new AtomicInteger(0);
    private final ConcurrentHashMap<String, SortInfo> sortInfoList = new ConcurrentHashMap();

    public static SortInfoManager getInstance() {
        return SortManagerHolder.INSTANCE;
    }

    private SortInfoManager() {
    }

    public void addSortInfo(SortInfo sortInfo) {
        if (sortInfo != null) {
            this.sortInfoList.put(sortInfo.getTrayCode(), sortInfo);
        }
    }

    public void clearSiteCodeMap() {
        this.siteCodeMap.clear();
    }

    public void clearSortInfoList() {
        this.sortInfoList.clear();
    }

    public boolean containsSortInfo(String key) {
        return this.sortInfoList.containsKey(key);
    }

    public void createSiteCodeValue(SortInfo sortInfo) {
        String siteCode = sortInfo.getSiteCode();
        if (siteCode == null || siteCode.equals("")) {
            return;
        }
        int siteCodeValue = 0;
        if (this.siteCodeMap.containsKey(siteCode)) {
            siteCodeValue = this.siteCodeMap.get(siteCode);
        } else {
            siteCodeValue = this.siteCodeSerial.incrementAndGet();
            this.siteCodeMap.put(siteCode, siteCodeValue);
        }
        sortInfo.setSiteCodeValue(siteCodeValue);
    }

    public SortInfo createSortInfo() {
        SortInfo sortInfo = new SortInfo();
        sortInfo.setSortingId(this.createSortingId());
        sortInfo.setBarcode("NoRead");
        return sortInfo;
    }

    public void doHandleNoRead(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoReadTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public SortInfo getSortInfo(String key) {
        return this.sortInfoList.get(key.toLowerCase());
    }

    public int getSortInfoCount() {
        return this.sortInfoList.size();
    }

    public SortInfo[] getSortInfoList() {
        return this.sortInfoList.values().toArray(new SortInfo[0]);
    }

    public void handleSortInfoResult(SortInfo sortInfo) {
        int errorCode = sortInfo.getErrorCodeSVR();
        switch (errorCode) {
            case 0: {
                this.doHandleSuccess(sortInfo);
                break;
            }
            case 1: {
                this.doHandleNoInfo(sortInfo);
                break;
            }
            case 9: {
                this.doHandleUnknownError(sortInfo);
                break;
            }
            case 10: {
                this.doHandleServerError(sortInfo);
                break;
            }
        }
    }

    public void postInitProcess() {
    }

    public SortInfo removeSortInfo(String key) {
        return this.sortInfoList.remove(key);
    }

    private String createSortingId() {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.substring(uuid.length() - 3);
        long now = System.currentTimeMillis();
        String uuidStr = uuid + now;
        return uuidStr;
    }

    private void doHandleServerError(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getServerErrorTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleUnknownError(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getUnknownErrorTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleNoInfo(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleSuccess(SortInfo sortInfo) {
        SortInfoManager.getInstance().createSiteCodeValue(sortInfo);
    }

    private static class SortManagerHolder {
        private static final SortInfoManager INSTANCE = new SortInfoManager();

        private SortManagerHolder() {
        }
    }
}

