/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.log.LogUtil;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IPacketOffController;
import com.simba.server.controllers.IPacketOnController;
import com.simba.server.controllers.IPlatScannedController;
import com.simba.server.controllers.ISlotPackController;
import com.simba.server.controllers.ISlotUnlockController;
import com.simba.server.controllers.ISortInfoController;
import com.simba.server.controllers.impl.PacketOffController;
import com.simba.server.controllers.impl.PacketOnController;
import com.simba.server.controllers.impl.PlatScannedController;
import com.simba.server.controllers.impl.SlotPackController;
import com.simba.server.controllers.impl.SlotUnlockController;
import com.simba.server.controllers.impl.SortInfoController;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SortControllerManager
implements IPacketOnController,
IPacketOffController,
IPlatScannedController,
ISortInfoController {
    private static final Logger logger = Logger.getLogger(SortControllerManager.class);
    private static final String SORT_INFO_MODE_ONLINE = "Online-Sorter-Mode";
    private String currentSortInfoMode;
    private final HashMap<String, IPacketOffController> packetOffControllers = new HashMap();
    private final HashMap<String, IPacketOnController> packetOnControllers = new HashMap();
    private final HashMap<String, IPlatScannedController> platMESControllers = new HashMap();
    private final HashMap<String, ISlotPackController> slotPackControllers = new HashMap();
    private final HashMap<String, ISlotUnlockController> slotUnlockControllers = new HashMap();
    private final HashMap<String, ISortInfoController> sortInfoControllers = new HashMap();

    public static SortControllerManager getInstance() {
        return SortBusinessManagerHolder.INSTANCE;
    }

    private SortControllerManager() {
    }

    public String getCurrentSortInfoMode() {
        return this.currentSortInfoMode;
    }

    public void init() {
        try {
            this.currentSortInfoMode = SORT_INFO_MODE_ONLINE;
            this.initPacketOnControllers();
            this.initSortInfoControllers();
            this.initPlatMESControllers();
            this.initPacketOffControllers();
            this.initSlotPackControllers();
            this.initSlotUnlockControllers();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortControllerManager] Init Sort Business Manager Error -- Exception : " + ex);
        }
    }

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        IPacketOffController controller = this.packetOffControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOffMessage(sortInfo);
        }
    }

    @Override
    public void onPacketOnMessage(PacketOnInfo packetOnInfo, Channel channel) {
        IPacketOnController controller = this.packetOnControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOnMessage(packetOnInfo, channel);
        }
    }

    @Override
    public void onPlatScannedMessage(SortInfo sortInfo) {
        IPlatScannedController controller = this.platMESControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPlatScannedMessage(sortInfo);
        }
    }

    public void onSlotPackMessage(SlotInfo slotInfo, Channel channel) {
        ISlotPackController controller = this.slotPackControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotPackMessage(slotInfo, channel);
        }
    }

    public void onSlotUnlockMessage(SlotInfo slotInfo, Channel channel) {
        ISlotUnlockController controller = this.slotUnlockControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotUnlockMessage(slotInfo, channel);
        }
    }

    @Override
    public void onSortInfoMessage(SortInfo sortInfo) {
        ISortInfoController controller = this.sortInfoControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSortInfoMessage(sortInfo);
        }
    }

    public void shutdown() {
    }

    private void initPacketOffControllers() {
        this.packetOffControllers.put(SORT_INFO_MODE_ONLINE, new PacketOffController());
    }

    private void initPacketOnControllers() {
        this.packetOnControllers.put(SORT_INFO_MODE_ONLINE, new PacketOnController());
    }

    private void initPlatMESControllers() {
        this.platMESControllers.put(SORT_INFO_MODE_ONLINE, new PlatScannedController());
    }

    private void initSlotPackControllers() {
        this.slotPackControllers.put(SORT_INFO_MODE_ONLINE, new SlotPackController());
    }

    private void initSlotUnlockControllers() {
        this.slotUnlockControllers.put(SORT_INFO_MODE_ONLINE, new SlotUnlockController());
    }

    private void initSortInfoControllers() {
        this.sortInfoControllers.put(SORT_INFO_MODE_ONLINE, new SortInfoController());
    }

    private static class SortBusinessManagerHolder {
        private static final SortControllerManager INSTANCE = new SortControllerManager();

        private SortBusinessManagerHolder() {
        }
    }
}

